/* ************************************************************************
 * 
 * MOENGAGE CONFIDENTIAL
 * __________________
 * 
 *  [2014] - [2015] MoEngage Inc. 
 *  All Rights Reserved.
 * 
 * NOTICE:  All information contained herein is, and remains
 * the property of MoEngage Inc. The intellectual and technical concepts
 * contained herein are proprietary to MoEngage Incorporated
 * and its suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from MoEngage Incorporated.
 */
package com.moe.pushlibrary.providers;

import android.content.Context;
import android.net.Uri;

public final class MoEDataContract {

  private MoEDataContract() {
    // Utility class should not be initialized
  }

  /**
   * Data contract for Datapoints Table
   */
  interface DatapointColumns extends BaseColumns {

    String DETAILS = "details";

    int COLUMN_INDEX_DETAILS = 2;
    /**
     * PROJECTION showing Events TABLE
     */
    String[] PROJECTION = { _ID, GTIME, DETAILS };
  }

  /**
   * Data Contract for the In-App Messaging Table
   */
  interface InAppMessageColumns extends BaseColumns {
    /**
     * The MoEngage campaign id of the campaign
     */
    String MSG_CAMPAIGN_ID = "campaign_id";
    /**
     * The Alignment type of the inapp possible values are "center/top/bottom/full/embed"
     */
    String MSG_ALIGN_TYPE = "align_type";
    /**
     * The InApp type. Possible Values are "general/advanced/self_handled/smart/static/linked"
     */
    String MSG_INAPP_TYPE = "inapp_type";
    /**
     * The Time To Live for the InApp. This is the expiry time
     */
    String MSG_TTL = "ttl";
    /**
     * The minimum delay between the same in app coming again
     */
    String MSG_MIN_DELAY = "min_delay";
    /**
     * The maximum number of times an inapp campaign can be shown
     */
    String MSG_MAX_TIMES = "max_times";
    /**
     * The number of times the in app campaign was shown
     */
    String MSG_SHOWN_COUNT = "shown_count";
    /**
     * Whether the in app message can be shown even after it is clicked
     */
    String MSG_PERSISTENT = "persistent";
    /**
     * The priority of ordering the in app. Showing of in-app messages is affected by this value
     */
    String MSG_PRIORITY = "priority";
    /**
     * The contextual information associated with the in app campaign. Can be empty
     */
    String MSG_CONTEXT = "context";
    /**
     * The last shown time of the in app message
     */
    String MSG_LAST_SHOWN = "last_shown";
    /**
     * The In App Message is clicked or not
     */
    String MSG_IS_CLICKED = "is_clicked";
    /**
     * States if the in-app messages have error or not. If it has errors then the campaign is
     * rejected
     */
    String MSG_HAS_ERRORS = "has_errors";
    /**
     * The auto dismiss time of the in app message. Can be empty as well.
     */
    String MSG_AUTODISMISS_TIME = "auto_dismiss";
    /**
     * The in app is cancelable or not
     */
    String MSG_CANCELABLE = "cancelable";
    /**
     * The content of the campaign which is essential for creating the in app view
     */
    String MSG_CONTENT = "content";
    /**
     * The name of the activity in which the inapp message can be shown
     */
    String MSG_SHOW_ONLY_IN = "show_only_in";
    /**
     * The status of the inapp campaign
     */
    String MSG_STATUS = "status";
    /**
     * The style associated with the DIM layer of the inapp. Can be null
     */
    String MSG_CONTAINER_STYLE = "dim_style";

    int COLUMN_INDEX_MSG_CAMPAIGN_ID = 2;
    int COLUMN_INDEX_MSG_ALIGN_TYPE = 3;
    int COLUMN_INDEX_MSG_INAPP_TYPE = 4;
    int COLUMN_INDEX_MSG_TTL = 5;
    int COLUMN_INDEX_MSG_MIN_DELAY = 6;
    int COLUMN_INDEX_MSG_MAX_TIMES = 7;
    int COLUMN_INDEX_MSG_SHOWN_COUNT = 8;
    int COLUMN_INDEX_MSG_PERSISTENT = 9;
    int COLUMN_INDEX_MSG_PRIORITY = 10;
    int COLUMN_INDEX_MSG_CONTEXT = 11;
    int COLUMN_INDEX_MSG_LAST_SHOWN = 12;
    int COLUMN_INDEX_MSG_IS_CLICKED = 13;
    int COLUMN_INDEX_MSG_HAS_ERRORS = 14;
    int COLUMN_INDEX_MSG_AUTODISMISS_TIME = 15;
    int COLUMN_INDEX_MSG_CANCELABLE = 16;
    int COLUMN_INDEX_MSG_CONTENT = 17;
    int COLUMN_INDEX_MSG_SHOW_ONLY_IN = 18;
    int COLUMN_INDEX_MSG_STATUS = 19;
    int COLUMN_INDEX_MSG_CONTAINER_STYLE = 20;
    /**
     * InApp Table projection
     */
    String[] PROJECTION = {
        _ID, GTIME, MSG_CAMPAIGN_ID, MSG_ALIGN_TYPE, MSG_INAPP_TYPE, MSG_TTL, MSG_MIN_DELAY,
        MSG_MAX_TIMES, MSG_SHOWN_COUNT, MSG_PERSISTENT, MSG_PRIORITY, MSG_CONTEXT, MSG_LAST_SHOWN,
        MSG_IS_CLICKED, MSG_HAS_ERRORS, MSG_AUTODISMISS_TIME, MSG_CANCELABLE, MSG_CONTENT,
        MSG_SHOW_ONLY_IN, MSG_STATUS, MSG_CONTAINER_STYLE
    };
    /**
     * The default sort order for this table
     */
    String DEFAULT_SORT_ORDER = MSG_PRIORITY + " DESC, " + GTIME + " DESC";
  }

  /**
   * The Base Columns which every entity extends
   */
  public interface BaseColumns {
    /**
     * The unique ID for a row.
     * <P>
     * Type: INTEGER (long)
     * </P>
     */
    String _ID = "_id";
    /**
     * The GMT Time associated with a record
     */
    String GTIME = "gtime";

    int COLUMN_INDEX_ID = 0;
    int COLUMN_INDEX_GTIME = 1;
  }

  /**
   * The base columns present in all tables
   */
  interface MessageColumns extends BaseColumns {
    /**
     * PromotionalMessage details associated with a record
     */
    String MSG_DETAILS = "msg";
    /**
     * Clicked state of the message associated with a record
     */
    String MSG_CLICKED = "msgclicked";
    /**
     * The Time to Live for the message associated with this record
     */
    String MSG_TTL = "msgttl";
    /**
     * Tag to differentiate between the different types of push messages.
     */
    String MSG_TAG = "msg_tag";

    String CAMPAIGN_ID = "campaign_id";

    int COLUMN_INDEX_MSG_DETAILS = 2;
    int COLUMN_INDEX_MSG_CLICKED = 3;
    int COLUMN_INDEX_MSG_TTL = 4;
    int COLUMN_INDEX_MSG_TAG = 5;

    /**
     * Messages Table projection
     */
    String[] PROJECTION = {
        _ID, GTIME, MSG_DETAILS, MSG_CLICKED, MSG_TTL, MSG_TAG, CAMPAIGN_ID
    };

    /**
     * The default sort order for this table
     */
    String DEFAULT_SORT_ORDER = BaseColumns.GTIME + " DESC";
  }


  interface UserAttributeColumns extends BaseColumns {

    String ATTRIBUTE_NAME = "attribute_name";

    String ATTRIBUTE_VALUE = "attribute_value";

    int COLUMN_INDEX_ATTRIBUTE_NAME = 1;

    int COLUMN_INDEX_ATTRIBUTE_VALUE = 2;
  }

  interface CampaignListColumns extends BaseColumns{
    String CAMPAIGN_ID = "campaign_id";
    String CAMPAIGN_ID_TTL = "ttl";

    int COLUMN_INDEX_CAMPAIGN_ID = 1;
    int COLUMN_INDEX_CAMPAIGN_ID_TTL = 2;
  }

  interface BatchDataColumns extends BaseColumns{
    String BATCHED_DATA = "batch_data";
  }

  interface DTColumns extends BaseColumns{
    /**
     * Campaign id
     */
    String CAMPAIGN_ID = "campaign_id";
    /**
     * campaign trigger event name
     */
    String TRIGGER_EVENT_NAME = "event_name";
    /**
     * Notification payload to be shown
     */
    String PAYLOAD = "payload";
    /**
     * Complete campaign payload
     */
    String CAMPAIGN_PAYLOAD = "campaign_payload";
    /**
     * Campaign type
     */
    String CAMPAIGN_TYPE = "campaign_type";
    /**
     * Maximum times campaign should be shown
     */
    String MAX_COUNT = "max_count";
    /**
     * Minimum delay before which campaign should not be shown again
     */
    String MINIMUM_DELAY = "minimum_delay";
    /**
     * should the campaign be shown if device is offline
     */
    String SHOULD_SHOW_OFFLINE = "should_show_offline";
    /**
     * maximum time which can elapse before next update.
     */
    String MAX_SYNC_DELAY_TIME = "max_sync_delay_time";
    /**
     * campaign expiry time.
     */
    String EXPIRY_TIME = "expiry_time";
    /**
     * campaign priority
     */
    String PRIORITY = "priority";
    /**
     * Time at which the campaign was last shown.
     */
    String LAST_SHOW_TIME = "last_show_time";
    /**
     * number of times campaign has been shown.
     */
    String SHOW_COUNT = "show_count";
    /**
     * last time campaign was updated.
     */
    String LAST_UPDATED_TIME = "last_updated_time";
    /**
     * State of the campaign active/paused/stopped
     */
    String STATUS = "status";
    /**
     * Should ignore DND or not
     */
    String SHOULD_IGNORE_DND = "should_ignore_dnd";
    String DELAY_BEFORE_SHOWING_NOTIFICATION = "delay_before_showing";

    int COLUMN_INDEX_CAMPAIGN_ID = 1;
    int COLUMN_INDEX_TRIGGER_EVENT_NAME = 2;
    int COLUMN_INDEX_PAYLOAD = 3;
    int COLUMN_INDEX_CAMPAIGN_PAYLOAD = 4;
    int COLUMN_INDEX_CAMPAIGN_TYPE = 5;
    int COLUMN_INDEX_MAX_COUNT = 6;
    int COLUMN_INDEX_MINIMUM_DELAY = 7;
    int COLUMN_INDEX_SHOULD_SHOW_OFFLINE = 8;
    int COLUMN_INDEX_MAX_SYNC_DELAY_TIME = 9;
    int COLUMN_INDEX_EXPIRY_TIME = 10;
    int COLUMN_INDEX_PRIORITY = 11;
    int COLUMN_INDEX_LAST_SHOW_TIME = 12;
    int COLUMN_INDEX_SHOW_COUNT = 13;
    int COLUMN_INDEX_LAST_UPDATED_TIME = 14;
    int COLUMN_INDEX_STATUS = 15;
    int COLUMN_INDEX_SHOULD_IGNORE_DND = 16;
    int COLUMN_INDEX_DELAY_BEFORE_SHOWING = 17;
  }

  interface AttributeCacheColumns extends BaseColumns{
    String ATTRIBUTE_NAME = "name";
    String ATTRIBUTE_VALUE = "value";
    String LAST_TRACKED_TIME = "last_tracked_time";
    String DATA_TYPE = "datatype";

    int COLUMN_INDEX_ATTRIBUTE_NAME = 1;
    int COLUMN_INDEX_ATTRIBUTE_VALUE = 2;
    int COLUMN_INDEX_LAST_TRACKED_TIME = 3;
    int COLUMN_INDEX_DATATYPE = 4;
  }

  /**
   * Class that represents a InAppMessage Entity. There is one entry per inapp
   * message
   */
  public static final class InAppMessageEntity implements InAppMessageColumns {

    public static Uri getContentUri(Context context) {
      return Uri.parse("content://" + getAuthority(context) + "/inapps");
    }

    /**
     * The MIME type of CONTENT_URIproviding a directory of
     * inapps.
     */
    static final String CONTENT_TYPE = "vnd.android.cursor.dir/vnd.moe.inapps";
    /**
     * The MIME type of a CONTENT_URIsub-directory of a single
     * inapp.
     */
    static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/vnd.moe.inapp";

    /**
     * Utility class cannot be instantiated
     */
    private InAppMessageEntity() {
      // Intentionally made private
    }
  }

  /**
   * Class that represents a Event Entity. There is one entry per event
   */
  public static final class DatapointEntity implements DatapointColumns {

    public static Uri getContentUri(Context context) {
      return Uri.parse("content://" + getAuthority(context) + "/datapoints");
    }

    /**
     * The MIME type of CONTENT_URIproviding a directory of
     * events.
     */
    public static final String CONTENT_TYPE = "vnd.android.cursor.dir/vnd.moe.datapoints";
    /**
     * The MIME type of a CONTENT_URIsub-directory of a single
     * event.
     */
    public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/vnd.moe.datapoint";

    /**
     * Utility class cannot be instantiated
     */
    private DatapointEntity() {
      // Intentionally made private
    }
  }

  /**
   * Class that represents a PromotionalMessage Entity. There is one entry per message
   */
  public static final class MessageEntity implements MessageColumns {

    /**
     * Returns the content uri for the message table
     *
     * @param context application context
     * @return content uri of Messages table
     */
    public static Uri getContentUri(Context context) {
      return Uri.parse("content://" + getAuthority(context) + "/messages");
    }

    /**
     * The MIME type of CONTENT_URIproviding a directory of
     * messages.
     */
    public static final String CONTENT_TYPE = "vnd.android.cursor.dir/vnd.moe.message";
    /**
     * The MIME type of a CONTENT_URIsub-directory of a single
     * message.
     */
    public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/vnd.moe.message";
    /**
     * The default sort order for this table
     */
    public static final String DEFAULT_SORT_ORDER = GTIME + " DESC";

    /**
     * Utility class cannot be instantiated
     */
    private MessageEntity() {
      // Intentionally made private
    }

    public static final int COLUMN_INDEX_MSG_DETAILS = 2;
    public static final int COLUMN_INDEX_MSG_CLICKED = 3;
    public static final int COLUMN_INDEX_MSG_TTL = 4;
    /**
     *
     */
    public static final String[] PROJECTION = {
        _ID, GTIME, MSG_DETAILS, MSG_CLICKED, MSG_TTL
    };
  }

  public static final class UserAttributeEntity implements UserAttributeColumns {
    /**
     * Returns the content uri for the message table
     *
     * @param context application context
     * @return content uri of UserAttribute table
     */
    public static Uri getContentUri(Context context) {
      return Uri.parse("content://" + getAuthority(context) + "/userattributes");
    }

    /**
     * The MIME type of CONTENT_URIproviding a directory of
     * messages.
     */
    public static final String CONTENT_TYPE = "vnd.android.cursor.dir/vnd.moe.userattributes";
    /**
     * The MIME type of a CONTENT_URIsub-directory of a single
     * message.
     */
    public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/vnd.moe.userattributes";

    public static final String[] PROJECTION = {
        _ID, ATTRIBUTE_NAME, ATTRIBUTE_VALUE
    };
  }

  public static final class CampaignListEntity implements CampaignListColumns {
    /**
     * Returns the content uri for the campaignList table
     *
     * @param context application context
     * @return content uri of UserAttribute table
     */
    public static Uri getContentUri(Context context) {
      return Uri.parse("content://" + getAuthority(context) + "/campaignlist");
    }

    /**
     * The MIME type of CONTENT_URIproviding a directory of
     * messages.
     */
    public static final String CONTENT_TYPE = "vnd.android.cursor.dir/vnd.moe.campaignlist";
    /**
     * The MIME type of a CONTENT_URIsub-directory of a single
     * message.
     */
    public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/vnd.moe.campaignlist";

    public static final String[] PROJECTION = {
        _ID, CAMPAIGN_ID, CAMPAIGN_ID_TTL
    };
  }

  public static final class BatchDataEntity implements BatchDataColumns{
    /**
     * Returns the content uri for the batchdata table
     *
     * @param context application context
     * @return content uri of UserAttribute table
     */
    public static Uri getContentUri(Context context) {
      return Uri.parse("content://" + getAuthority(context) + "/batchdata");
    }

    /**
     * The MIME type of CONTENT_URIproviding a directory of
     * messages.
     */
    public static final String CONTENT_TYPE = "vnd.android.cursor.dir/vnd.moe.batchdata";
    /**
     * The MIME type of a CONTENT_URI sub-directory of a single
     * message.
     */
    public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/vnd.moe.batchdata";

    public static final String[] PROJECTION = {
        _ID, BATCHED_DATA
    };
  }

  public static final class DTEntity implements DTColumns{
    /**
     * Returns the content uri for the DeviceTriggers table
     *
     * @param context application context
     * @return content uri of DeviceTriggers table
     */
    public static Uri getContentUri(Context context) {
      return Uri.parse("content://" + getAuthority(context) + "/dtcampaign");
    }

    /**
     * The MIME type of CONTENT_URI providing a directory of
     * messages.
     */
    public static final String CONTENT_TYPE = "vnd.android.cursor.dir/vnd.moe.dtcampaign";
    /**
     * The MIME type of a CONTENT_URI sub-directory of a single
     * message.
     */
    public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/vnd.moe.dtcampaign";

    public static final String[] PROJECTION = {
        _ID, CAMPAIGN_ID, TRIGGER_EVENT_NAME, PAYLOAD, CAMPAIGN_PAYLOAD, CAMPAIGN_TYPE, MAX_COUNT,
        MINIMUM_DELAY,
        SHOULD_SHOW_OFFLINE, MAX_SYNC_DELAY_TIME, EXPIRY_TIME, PRIORITY, LAST_SHOW_TIME, SHOW_COUNT,
        LAST_UPDATED_TIME, STATUS, SHOULD_IGNORE_DND, DELAY_BEFORE_SHOWING_NOTIFICATION
    } ;

    public static String DEFAULT_SORT_ORDER = PRIORITY + " DESC, " + LAST_UPDATED_TIME + " DESC";
  }

  public static final class AttributeCacheEntity implements AttributeCacheColumns {
    public static Uri getContentUri(Context context) {
      return Uri.parse("content://" + getAuthority(context) + "/attributecache");
    }

    /**
     * The MIME type of CONTENT_URI providing a directory of
     * messages.
     */
    public static final String CONTENT_TYPE = "vnd.android.cursor.dir/vnd.moe.attributecache";
    /**
     * The MIME type of a CONTENT_URI sub-directory of a single
     * message.
     */
    public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/vnd.moe.attributecache";

    public static final String[] PROJECTION = {
        _ID, ATTRIBUTE_NAME, ATTRIBUTE_VALUE, LAST_TRACKED_TIME, DATA_TYPE
    } ;

  }

  private static final String AUTHORITY_PART = ".moengage.provider";

  public static final String QUERY_PARAMETER_LIMIT = "LIMIT";

  /**
   * This authority is used for writing to or querying from the MoEProvider
   * provider. Note: This is set at first run and cannot be changed without
   * breaking apps that access the provider.
   */
  private static String AUTHORITY = null;

  /**
   * @param context application context
   * @return Authority string pointing to the Provider
   */
  public static String getAuthority(Context context) {
    if (null == AUTHORITY) {
      String packageName = context.getPackageName();
      AUTHORITY = packageName + AUTHORITY_PART;
    }
    return AUTHORITY;
  }
}
