package com.moengage.core.pushamp;

import android.content.Context;
import com.moengage.core.Logger;

/**
 * @author Umang Chamaria
 * Date: 10/04/19
 */
public class PushAmpManager {
  private static final String TAG = "PushAmpManager";

  private PushAmpHandler handler = null;
  private static PushAmpManager instance;

  private PushAmpManager(){
    loadHandler();
  }

  public static PushAmpManager getInstance(){
    if (instance == null){
      synchronized (PushAmpManager.class){
        if (instance == null) instance = new PushAmpManager();
      }
    }
    return instance;
  }

  private void loadHandler() {
    try {
      Class clazz = Class.forName("com.moengage.pushamp.PushAmpHandlerImpl");
      handler = (PushAmpHandler) clazz.newInstance();
      Logger.v(TAG + ":loadHandler Push Amp Module found.");
    } catch (Exception e) {
      Logger.e(TAG + " : loadHandler : Push Amp Module not found. ");
    }
  }

  public void scheduleServerSync(Context context){
    if (handler != null){
      handler.scheduleServerSync(context);
    }
  }

  public void forceServerSync(Context context, boolean isAppOpen){
    if (handler != null){
      handler.foregroundServerSync(context, isAppOpen);
    }
  }
}
