package com.moengage.core;

import android.content.Context;
import android.text.TextUtils;
import com.moengage.ActionMapperConstants;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.inapp.InAppController;
import java.util.HashMap;
import org.json.JSONObject;

/**
 * API Calls related to in-apps
 *
 * @author Umang Chamaria
 */
public class InAppNetworkCallsTask extends SDKTask {

  private HashMap<String, String> paramsMap;
  String API;
  private JSONObject requestBody;
  private InAppController.NETWORK_CALL_TYPE networkCallType;
  private InAppController.InAppHandler inAppHandler;

  public InAppNetworkCallsTask(Context context, String API, HashMap<String, String> paramsMap,
      JSONObject requestBody, InAppController.NETWORK_CALL_TYPE networkCallType) {
    super(context);
    this.API = API;
    this.paramsMap = paramsMap;
    this.requestBody = requestBody;
    this.networkCallType = networkCallType;
  }

  @Override public TaskResult execute() {
    Logger.v("InAppNetworkCallsTask : started execution, Task Type : " + networkCallType);
    String response = null;
    JSONObject jsonResponse;
    try {
      if (!ConfigurationCache.getInstance().getRemoteConfiguration().isInAppEnabled()
          || !ConfigurationCache.getInstance().getRemoteConfiguration().isAppEnabled()) {
        return null;
      }
      switch (networkCallType) {
        case SYNC_IN_APPS:
          Logger.v("InAppNetworkCallsTask: executing sync in-apps");
          taskResult.setPayload(InAppController.NETWORK_CALL_TYPE.SYNC_IN_APPS);
          response = APIManager.fetchInAppCampaigns(context, API, paramsMap, requestBody);
          if (!TextUtils.isEmpty(response)) {
            jsonResponse = new JSONObject(response);
            InAppController.getInstance().parseAndSaveInApps(context, jsonResponse);
            taskResult.setIsSuccess(true);
          } else {
            Logger.e("MoEParser:parseAndSaveCampaignInfo not a valid response");
          }
          break;
        case AUTO_TRIGGER_EVENT:
          Logger.v("InAppNetworkCallsTask: executing auto-trigger in-apps");
          response = APIManager.logASmartEvent(context, API, paramsMap, requestBody);
          if (!TextUtils.isEmpty(response)) {
            jsonResponse = new JSONObject(response);
            InAppController.getInstance().tryShowAutoTriggerInApp(context, jsonResponse);
          }
          break;
        case SINGLE_FETCH:
          Logger.v("InAppNetworkCallsTask: executing single fetch in-apps");
          response = APIManager.fetchSingleInApp(context, API, paramsMap);
          if (!TextUtils.isEmpty(response)) {
            jsonResponse = new JSONObject(response);
            InAppController.getInstance().showLinkedInApp(context, jsonResponse, paramsMap);
          } else {
            String errorString =
                "Network Error Could not show test in-app.\n CampaignId : "
                    + paramsMap.get(ActionMapperConstants.KEY_CAMPAIGN_ID)
                    + ".\nPlease try again or "
                    + "contact MoEngage Support with the screenshot.";
            InAppController.getInstance().showTestInAppErrorDialog(context, errorString);
          }
          break;
      }
    } catch (Exception e) {
      Logger.f("InAppNetworkCallsTask : execute JSONException", e);
    }
    Logger.v("InAppNetworkCallsTask : completed execution");
    return taskResult;
  }

  @Override public String getTaskTag() {
    return TAG_INAPP_NETWORK_TASK;
  }

  @Override public boolean isSynchronous() {
    return false;
  }
}
