package com.moengage.core;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobInfo.Builder;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build.VERSION;
import android.os.Build.VERSION_CODES;
import android.text.TextUtils;
import com.moe.pushlibrary.MoEHelper;
import com.moe.pushlibrary.MoEWorker;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;

/**
 * Logs activity stop event
 * Service Constant MSG_ACTIVITY_STOP
 *
 * @author Umang Chamaria
 */
class ActivityStopTask extends SDKTask {

  private static final String TAG = "ActivityStopTask";

  private String activityName;

  private int DATA_SYNC_JOB_ID = 99999;

  ActivityStopTask(Context context, String currentActivityName) {
    super(context);
    activityName = currentActivityName;
  }

  @Override public TaskResult execute() {
    try {
      Logger.v(TAG + " executing task");
      if (!TextUtils.isEmpty(activityName)) {
        Logger.v("ActivityLifecycleStop : " + activityName + " stopped");
      }
      Logger.d("ActivityStopTask: activity counter " + MoEHelper.getActivityCounter());
      if (MoEHelper.getActivityCounter() == 0) {
        Logger.v("ActivityStopTask: Activity counter zero, will try to send "
            + "interaction data");
        MoEDispatcher.getInstance(context).onAppClose();
        // schedule data sending
        if (VERSION.SDK_INT < VERSION_CODES.LOLLIPOP){
          scheduleDataSending();
        }else {
          scheduleDataSendingJob();
        }
      }
      Logger.v(TAG + " completed execution");
    } catch (Exception e) {
      Logger.e( TAG + " execute() : Exception: ", e);
    }
    return null;
  }

  @Override public String getTaskTag() {
    return TAG_ACTIVITY_STOP;
  }

  @Override public boolean isSynchronous() {
    return false;
  }

  private void scheduleDataSending() {
    Logger.v(TAG + " scheduleDataSending()");
    Intent alarmIntent = new Intent(context, MoEAlarmReceiver.class);
    PendingIntent pendingIntent =
        PendingIntent.getBroadcast(context, MoEWorker.REQ_CODE_SEND_DATA, alarmIntent,
            PendingIntent.FLAG_UPDATE_CURRENT);
    AlarmManager alarmManager = (AlarmManager) context.getSystemService(Context.ALARM_SERVICE);
    if (alarmManager != null) {
      alarmManager.set(AlarmManager.RTC_WAKEUP, System.currentTimeMillis() + (3 * 1000),
          pendingIntent);
    }
  }

  @TargetApi(VERSION_CODES.LOLLIPOP)
  private void scheduleDataSendingJob(){
    Logger.v(TAG + " scheduleDataSendingJob()");
    ComponentName serviceComponent = new ComponentName(context, DataSyncJob.class);
    JobInfo.Builder builder = new Builder(DATA_SYNC_JOB_ID, serviceComponent);
    builder.setRequiredNetworkType(JobInfo.NETWORK_TYPE_ANY);
    builder.setOverrideDeadline(System.currentTimeMillis() + 5000);
    builder.setMinimumLatency(2000);
    JobScheduler jobScheduler =
        (JobScheduler) context.getSystemService(Context.JOB_SCHEDULER_SERVICE);
    if (jobScheduler != null) {
      jobScheduler.schedule(builder.build());
    }
  }


}
