/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.mipush;

import android.app.Application;
import com.moe.pushlibrary.MoEHelper;
import com.moengage.core.ConfigurationCache;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.mipush.MiPushHandler;

public class MiPushManager {
    private static final String TAG = "MiPushManager";
    private MiPushHandler miPushHandler;
    private static MiPushManager instance;

    private MiPushManager() {
        this.loadHandler();
    }

    private void loadHandler() {
        try {
            Class<?> handler = Class.forName("com.moengage.mi.MiPushHandlerImpl");
            this.miPushHandler = (MiPushHandler)handler.newInstance();
        }
        catch (Exception e) {
            Logger.e("MiPushManager loadHandler() : Did not find Push Amp plus Module. ");
        }
    }

    public static MiPushManager getInstance() {
        if (instance == null) {
            instance = new MiPushManager();
        }
        return instance;
    }

    public void initMiPush(Application application) {
        if (this.miPushHandler != null && MoEUtils.canEnableMiPush(ConfigurationCache.getInstance().getRemoteConfiguration())) {
            ConfigurationProvider.getInstance(application.getApplicationContext()).savePushService("MI_PUSH");
            this.miPushHandler.initMiPushIfRequired(MoEHelper.getInstance(application.getApplicationContext()).getApplication());
        } else {
            ConfigurationProvider.getInstance(application.getApplicationContext()).savePushService("FCM");
        }
    }

    public boolean hasMiPushModule() {
        return this.miPushHandler != null;
    }
}

