/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.app.Activity;
import android.app.job.JobParameters;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.moe.pushlibrary.MoEHelper;
import com.moe.pushlibrary.PayloadBuilder;
import com.moe.pushlibrary.models.Event;
import com.moe.pushlibrary.providers.MoEDataContract;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.ActivityStartTask;
import com.moengage.core.ActivityStopTask;
import com.moengage.core.ConfigurationCache;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.DeviceAddManager;
import com.moengage.core.Logger;
import com.moengage.core.MoECoreEvaluator;
import com.moengage.core.MoEDAO;
import com.moengage.core.MoEDTManager;
import com.moengage.core.MoEUtils;
import com.moengage.core.MoEWorkerTask;
import com.moengage.core.NotificationClickedTask;
import com.moengage.core.OnJobComplete;
import com.moengage.core.SendInteractionDataTask;
import com.moengage.core.SetAliasTask;
import com.moengage.core.SetDeviceAttributeTask;
import com.moengage.core.analytics.AnalyticsHelper;
import com.moengage.core.events.MoEEventManager;
import com.moengage.core.executor.ITask;
import com.moengage.core.executor.OnTaskCompleteListener;
import com.moengage.core.executor.TaskProcessor;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.listeners.OnAppBackgroundListener;
import com.moengage.core.listeners.OnLogoutCompleteListener;
import com.moengage.core.mipush.MiPushManager;
import com.moengage.core.pushamp.PushAmpManager;
import com.moengage.core.remoteconfig.ConfigApiNetworkTask;
import com.moengage.core.reports.ReportsBatchHelper;
import com.moengage.core.userattributes.MoEAttributeManager;
import com.moengage.inapp.InAppController;
import com.moengage.location.GeoManager;
import com.moengage.push.PushHandler;
import com.moengage.push.PushManager;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class MoEDispatcher
implements OnTaskCompleteListener {
    private static final String TAG = "MoEDispatcher";
    private Context context;
    private ConfigurationProvider configProvider;
    private TaskProcessor taskProcessor;
    private static MoEDispatcher instance;
    private boolean shouldClearData = false;
    private HashMap<String, Boolean> runningTaskList;
    private boolean shouldTrackUniqueId = false;
    private JSONObject uniqueIdAttribute = null;
    private ScheduledExecutorService mScheduler;
    private OnLogoutCompleteListener logoutCompleteListener;
    private MoEAttributeManager attributeManager = null;
    private DeviceAddManager deviceAddManager = null;
    private MoECoreEvaluator coreEvaluator = null;
    private ReportsBatchHelper batchHelper = null;

    private MoEDispatcher(Context context) {
        if (context != null) {
            this.context = context;
            this.configProvider = ConfigurationProvider.getInstance(this.context);
            this.taskProcessor = TaskProcessor.getInstance();
            this.runningTaskList = new HashMap();
            this.taskProcessor.setOnTaskCompleteListener(this);
            this.attributeManager = new MoEAttributeManager(context);
        } else {
            Logger.e("MoEDispatcher  : context is null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MoEDispatcher getInstance(Context context) {
        if (instance != null) return instance;
        Class<MoEDispatcher> clazz = MoEDispatcher.class;
        synchronized (MoEDispatcher.class) {
            if (instance != null) return instance;
            instance = new MoEDispatcher(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public void checkForInAppMessages(boolean force) {
        Logger.v("MoEDispatcher: showInAppIfPossible: Check in app messages");
        if (force) {
            InAppController.getInstance().showInAppIfEligible(this.context);
        }
    }

    public void onStart(Activity activity, Intent intent) {
        if (!ConfigurationCache.getInstance().getRemoteConfiguration().isAppEnabled()) {
            return;
        }
        if (null == activity) {
            Logger.e("MoEDispatcher:onStart activity instance is null");
            return;
        }
        if (null == intent) {
            intent = activity.getIntent();
        }
        this.context = activity.getApplicationContext();
        Logger.v("MoEDispatcher:onStart ----");
        MoEHelperUtils.dumpIntentExtras(intent);
        String currentActivityName = activity.getClass().getName();
        this.addTaskToQueue(new ActivityStartTask(activity));
        Context context = activity.getApplicationContext();
        int currentOrientation = context.getResources().getConfiguration().orientation;
        String savedActivityName = InAppController.getInstance().getActivityName();
        int savedOrientation = InAppController.getInstance().getActivityOrientation();
        if (savedActivityName != null && savedOrientation != -1) {
            if (savedActivityName.equals(currentActivityName) && savedOrientation != currentOrientation) {
                InAppController.getInstance().showInAppOnConfigurationChange(this.context);
            } else {
                this.saveCurrentActivityDetails(currentActivityName, currentOrientation);
                this.syncInAppsAndGeo();
            }
        } else {
            this.saveCurrentActivityDetails(currentActivityName, currentOrientation);
            this.syncInAppsAndGeo();
        }
        this.saveCurrentActivityDetails(currentActivityName, currentOrientation);
        if (MoEHelper.getActivityCounter() == 1) {
            this.pushTokenFallBack();
        }
        MoEUtils.updateTestDeviceState(this.context);
    }

    private void pushTokenFallBack() {
        PushHandler pushHandler = PushManager.getInstance().getPushHandler();
        if (pushHandler != null) {
            pushHandler.setPushRegistrationFallback(this.context);
        }
    }

    private void syncInAppsAndGeo() {
        if (!ConfigurationCache.getInstance().getRemoteConfiguration().isAppEnabled()) {
            return;
        }
        Logger.v("MoEDispatcher: Fetch or query in app message");
        InAppController.getInstance().showInAppIfEligible(this.context);
        GeoManager.getInstance().updateFenceAndLocation(this.context);
    }

    public void trackNotificationClicked(long gtime) {
        if (!ConfigurationCache.getInstance().getRemoteConfiguration().isAppEnabled()) {
            return;
        }
        this.addTaskToQueue(new NotificationClickedTask(this.context, gtime));
    }

    public void setUserAttribute(JSONObject userJson) {
        this.attributeManager.setUserAttribute(userJson);
    }

    public void setCustomUserAttribute(JSONObject userJson) {
        this.attributeManager.setCustomUserAttribute(userJson);
    }

    public void setExistingUser(boolean existing) {
        try {
            if (!ConfigurationCache.getInstance().getRemoteConfiguration().isAppEnabled()) {
                return;
            }
            boolean installRegistered = ConfigurationProvider.getInstance(this.context).isInstallRegistered();
            int currentVersion = this.configProvider.getAppVersion();
            if (existing) {
                int prevVersion = this.configProvider.getStoredAppVersion();
                if (currentVersion == prevVersion) {
                    return;
                }
                this.configProvider.storeAppVersion(currentVersion);
                PayloadBuilder eventObj = new PayloadBuilder().putAttrInt("VERSION_FROM", prevVersion).putAttrInt("VERSION_TO", currentVersion).putAttrDate("UPDATED_ON", new Date());
                MoEEventManager.getInstance(this.context).trackEvent("UPDATE", eventObj);
                Logger.v("MoEDispatcher:setExistingUser:tracking update");
            } else if (!installRegistered) {
                this.configProvider.storeAppVersion(currentVersion);
                PayloadBuilder builder = new PayloadBuilder();
                builder.putAttrInt("VERSION", currentVersion).putAttrInt("sdk_ver", 9800).putAttrLong("INSTALLED_TIME", System.currentTimeMillis()).putAttrString("os", "ANDROID");
                MoEEventManager.getInstance(this.context).trackEvent("INSTALL", builder);
                Logger.v("MoEDispatcher:setExistingUser:tracking install");
            }
        }
        catch (Exception e) {
            Logger.f("MoEDispatcher: setExistingUser: ", e);
        }
    }

    void cancelRegistrationFallback() {
        MoEUtils.setRegistrationScheduled(this.context, false);
        MoEUtils.saveCurrentExponentialCounter(this.context, 1);
    }

    public void onResume(Activity activity, boolean isRestoring) {
        if (!ConfigurationCache.getInstance().getRemoteConfiguration().isAppEnabled()) {
            return;
        }
        if (!isRestoring) {
            this.showDialogAfterPushClick(activity);
        }
    }

    public void onStop(Activity activity, boolean configChange) {
        if (!ConfigurationCache.getInstance().getRemoteConfiguration().isAppEnabled()) {
            return;
        }
        if (null == activity) {
            return;
        }
        if (configChange) {
            return;
        }
        this.addTaskToQueue(new ActivityStopTask(this.context, activity.getClass().getName()));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @WorkerThread
    public void handleLogout(boolean isForcedLogout) {
        Logger.i("Started logout process");
        if (!ConfigurationCache.getInstance().getRemoteConfiguration().isAppEnabled()) {
            return;
        }
        this.trackLogoutEvent(isForcedLogout);
        this.addTaskToQueueBeginning(new SendInteractionDataTask(this.context));
        this.shouldClearData = true;
    }

    private void trackLogoutEvent(boolean isForcedLogout) {
        try {
            PayloadBuilder eventAttributes = new PayloadBuilder();
            if (isForcedLogout) {
                eventAttributes.putAttrString("type", "forced");
            }
            eventAttributes.setNonInteractive();
            Event event = new Event("MOE_LOGOUT", eventAttributes.build());
            MoEDAO.getInstance(this.context).addEvent(event);
        }
        catch (Exception e) {
            Logger.f("MoEDispatcher: trackLogoutEvent(): ", e);
        }
    }

    @WorkerThread
    private void clearDataOnLogout() {
        this.context.getContentResolver().delete(MoEDataContract.DatapointEntity.getContentUri(this.context), null, null);
        this.context.getContentResolver().delete(MoEDataContract.MessageEntity.getContentUri(this.context), null, null);
        this.context.getContentResolver().delete(MoEDataContract.InAppMessageEntity.getContentUri(this.context), null, null);
        this.context.getContentResolver().delete(MoEDataContract.UserAttributeEntity.getContentUri(this.context), null, null);
        this.context.getContentResolver().delete(MoEDataContract.CampaignListEntity.getContentUri(this.context), null, null);
        this.context.getContentResolver().delete(MoEDataContract.BatchDataEntity.getContentUri(this.context), null, null);
        this.context.getContentResolver().delete(MoEDataContract.DTEntity.getContentUri(this.context), null, null);
        MoEDAO.getInstance(this.context).clearAttributeCache();
        this.configProvider.removeUserConfigurationOnLogout();
        AnalyticsHelper.getInstance(this.context).onLogout(this.context);
        this.notifyLogoutCompleteListener();
        PushHandler pushHandler = PushManager.getInstance().getPushHandler();
        if (pushHandler != null) {
            pushHandler.registerForPushToken(this.context);
        }
        this.deviceAddManager.registerDevice(this.context);
        this.shouldClearData = false;
        Logger.i("Completed logout process");
    }

    public void sendInteractionData() {
        this.startTask(new SendInteractionDataTask(this.context));
    }

    public void sendInteractionData(OnJobComplete jobComplete, JobParameters parameters) {
        this.startTask(new SendInteractionDataTask(this.context, jobComplete, parameters));
    }

    public void onFragmentStart(Activity activity, String fragmentName) {
        this.syncInAppsAndGeo();
    }

    @WorkerThread
    public void setInboxMessageClicked(long id2) {
        MoEDAO.getInstance(this.context).setMessageClicked(id2);
    }

    @WorkerThread
    void handleAppUpdateEvent() {
        try {
            if (!ConfigurationCache.getInstance().getRemoteConfiguration().isAppEnabled()) {
                return;
            }
            int prevVersion = this.configProvider.getStoredAppVersion();
            PayloadBuilder eventObj = new PayloadBuilder();
            eventObj.putAttrInt("VERSION_FROM", prevVersion);
            eventObj.putAttrInt("VERSION_TO", this.configProvider.getAppVersion());
            Logger.i("Adding an update event");
            MoEEventManager.getInstance(this.context).trackEvent("UPDATE", eventObj);
            if (!MoEHelper.isAppInForeground()) {
                this.sendInteractionData();
            }
        }
        catch (Exception e) {
            Logger.f("Adding update event", e);
        }
    }

    @Nullable
    @WorkerThread
    public Cursor getAllMessages() {
        return MoEDAO.getInstance(this.context).getMessages(this.context);
    }

    @WorkerThread
    public int getUnreadMessageCount() {
        return MoEDAO.getInstance(this.context).getUnreadMessageCount();
    }

    public void initialize(String senderId, String appId) {
        if (!TextUtils.isEmpty((CharSequence)appId)) {
            this.configProvider.saveAppDetails(senderId, appId);
            this.dispatchPushTask("MOE_REG_REQ");
        } else {
            Logger.e("MoEDispatcher: initialize : AppId is null");
        }
    }

    public void checkAndShowLinkedInApp(String campaignId) {
        InAppController.getInstance().fetchLinkedInApp(this.context, campaignId);
    }

    private void showDialogAfterPushClick(Activity activity) {
        if (null == activity) {
            return;
        }
        try {
            Bundle extras;
            Intent intent = activity.getIntent();
            if (intent != null && (extras = intent.getExtras()) != null && extras.containsKey("gcm_show_dialog")) {
                intent.removeExtra("gcm_show_dialog");
                if (extras.containsKey("gcm_coupon_code")) {
                    MoEUtils.showCouponDialog(extras.getString("gcm_alert"), extras.getString("gcm_coupon_code"), (Context)activity);
                    intent.removeExtra("gcm_alert");
                    intent.removeExtra("gcm_coupon_code");
                } else {
                    MoEUtils.showNormalDialogWithOk(extras.getString("gcm_alert"), (Context)activity);
                    intent.removeExtra("gcm_alert");
                }
            }
        }
        catch (Exception e) {
            Logger.f("MoEDispatcher: showDialogAfterPushClick : ", e);
        }
    }

    private void saveCurrentActivityDetails(String currActivityName, int currentOrientation) {
        InAppController.getInstance().setActivityName(currActivityName);
        InAppController.getInstance().setActivityOrientation(currentOrientation);
    }

    public void addTaskToQueue(ITask task) {
        Logger.v("Trying to add " + task.getTaskTag() + " to the queue");
        if (this.canAddTaskToQueue(task)) {
            Logger.v(task.getTaskTag() + " added to queue");
            this.runningTaskList.put(task.getTaskTag(), task.isSynchronous());
            this.taskProcessor.addTask(task);
        } else {
            Logger.v("MoEDispatcher addTaskToQueue() : Task is already queued. Cannot add it to queue.");
        }
    }

    public void addTaskToQueueBeginning(ITask task) {
        Logger.v("Trying to add " + task.getTaskTag() + " to the queue");
        if (this.canAddTaskToQueue(task)) {
            Logger.v(task.getTaskTag() + " added to beginning of queue");
            this.runningTaskList.put(task.getTaskTag(), task.isSynchronous());
            this.taskProcessor.addTaskToFront(task);
        } else {
            Logger.v("MoEDispatcher addTaskToQueueBeginning() : Task is already queued. Cannot add it to queue.");
        }
    }

    public void startTask(ITask task) {
        Logger.v("MoEDispatcher startTask() : Try to start task");
        if (this.canAddTaskToQueue(task)) {
            Logger.v(task.getTaskTag() + " Starting task");
            this.runningTaskList.put(task.getTaskTag(), task.isSynchronous());
            this.taskProcessor.startTask(task);
        } else {
            Logger.v("MoEDispatcher startTask() : Cannot start task. Task is already in progress or queued.");
        }
    }

    @Override
    public void onTaskComplete(String tag, TaskResult taskResult) {
        Logger.v("Task completed : " + tag);
        if (this.runningTaskList.containsKey(tag)) {
            this.runningTaskList.remove(tag);
        }
        switch (tag) {
            case "SEND_INTERACTION_DATA": {
                if (!this.shouldClearData) break;
                this.clearDataOnLogout();
                if (!this.shouldTrackUniqueId) break;
                this.trackChangedUniqueId();
                break;
            }
            case "TRACK_ATTRIBUTE": {
                if (taskResult.isSuccess()) break;
                this.shouldTrackUniqueId = true;
                this.uniqueIdAttribute = (JSONObject)taskResult.getPayload();
                break;
            }
            case "DEVICE_ADD": {
                this.deviceAddManager.processTaskResult(this.context, taskResult);
                break;
            }
            case "SYNC_CONFIG": {
                this.onConfigApiSyncComplete(taskResult);
            }
        }
    }

    private void dispatchPushTask(String extra) {
        PushHandler pushHandler = PushManager.getInstance().getPushHandler();
        if (pushHandler != null) {
            pushHandler.offLoadToWorker(this.context, extra);
        }
    }

    public void logPushFailureEvent(Context context, String e) {
    }

    private void syncConfigIfRequired() {
        if (this.configProvider.getLastConfigSyncTime() + 3600000L < MoEUtils.currentTime()) {
            this.startTask(new ConfigApiNetworkTask(this.context));
        }
    }

    public void trackDeviceLocale() {
        try {
            if (!ConfigurationCache.getInstance().getRemoteConfiguration().isAppEnabled()) {
                return;
            }
            this.trackDeviceAndUserAttribute("LOCALE_COUNTRY", Locale.getDefault().getCountry());
            this.trackDeviceAndUserAttribute("LOCALE_COUNTRY_DISPLAY", Locale.getDefault().getDisplayCountry());
            this.trackDeviceAndUserAttribute("LOCALE_LANGUAGE", Locale.getDefault().getLanguage());
            this.trackDeviceAndUserAttribute("LOCALE_LANGUAGE_DISPLAY", Locale.getDefault().getDisplayLanguage());
            this.trackDeviceAndUserAttribute("LOCALE_DISPLAY", Locale.getDefault().getDisplayName());
            this.trackDeviceAndUserAttribute("LOCALE_COUNTRY_ ISO3", Locale.getDefault().getISO3Country());
            this.trackDeviceAndUserAttribute("LOCALE_LANGUAGE_ISO3", Locale.getDefault().getISO3Language());
        }
        catch (Exception e) {
            Logger.f("MoEDispatcher : trackDeviceLocale", e);
        }
    }

    private void trackDeviceAndUserAttribute(String attrName, String attrValue) {
        try {
            JSONObject attribute = new JSONObject();
            attribute.put(attrName, (Object)attrValue);
            this.setUserAttribute(attribute);
        }
        catch (Exception e) {
            Logger.f("MoEDispatcher: trackDeviceAndUserAttribute() ", e);
        }
    }

    public void logoutUser(boolean isForcedLogout) {
        try {
            Bundle extras = new Bundle();
            extras.putBoolean("IS_FORCE_LOGOUT", isForcedLogout);
            this.addTaskToQueue(new MoEWorkerTask(this.context, "LOGOUT", extras));
        }
        catch (Exception e) {
            Logger.f("MoEDispatcher: logoutUser() ", e);
        }
    }

    private void trackChangedUniqueId() {
        if (this.uniqueIdAttribute != null) {
            this.setUserAttribute(this.uniqueIdAttribute);
            this.uniqueIdAttribute = null;
            this.shouldTrackUniqueId = false;
        }
    }

    public void setAlias(JSONObject aliasJSON) {
        if (!ConfigurationCache.getInstance().getRemoteConfiguration().isAppEnabled()) {
            return;
        }
        this.addTaskToQueue(new SetAliasTask(this.context, aliasJSON));
    }

    public void setDeviceAttribute(JSONObject deviceAttribute) {
        this.addTaskToQueue(new SetDeviceAttributeTask(this.context, deviceAttribute));
    }

    private void schedulePeriodicFlushIfRequired() {
        try {
            if (ConfigurationCache.getInstance().getRemoteConfiguration().isPeriodicFlushEnabled() && MoEHelper.getInstance(this.context).getPeriodicSyncState()) {
                Runnable syncRunnable = new Runnable(){

                    @Override
                    public void run() {
                        Logger.v("MoEDispatcher: schedulePeriodicFlushIfRequired() inside runnable, will sync now");
                        MoEDispatcher.this.sendInteractionData();
                    }
                };
                long timeDelay = ConfigurationCache.getInstance().getRemoteConfiguration().getPeriodicFlushTime();
                if (MoEHelper.getInstance(this.context).getFlushInterval() > timeDelay) {
                    timeDelay = MoEHelper.getInstance(this.context).getFlushInterval();
                }
                Logger.v("MoEDispatcher: schedulePeriodicFlushIfRequired() scheduling periodic sync");
                this.mScheduler = Executors.newScheduledThreadPool(1);
                this.mScheduler.scheduleWithFixedDelay(syncRunnable, timeDelay, timeDelay, TimeUnit.SECONDS);
            }
        }
        catch (Exception e) {
            Logger.e("MoEDispatcher: schedulePeriodicFlushIfRequired() ", e);
        }
    }

    private void shutDownPeriodicFlush() {
        try {
            if (ConfigurationCache.getInstance().getRemoteConfiguration().isPeriodicFlushEnabled() && MoEHelper.getInstance(this.context).getPeriodicSyncState() && this.mScheduler != null) {
                Logger.v("MoEDispatcher: shutDownPeriodicFlush() shutting down periodic flush");
                this.mScheduler.shutdownNow();
            }
        }
        catch (Exception e) {
            Logger.f("MoEDispatcher: shutDownPeriodicFlush() ", e);
        }
    }

    public void onAppOpen() {
        try {
            this.syncConfigIfRequired();
            InAppController.getInstance().syncInAppIfRequired(this.context);
            PushAmpManager.getInstance().forceServerSync(this.context, true);
            PushHandler pushHandler = PushManager.getInstance().getPushHandler();
            if (pushHandler != null) {
                pushHandler.offLoadToWorker(this.context, "REG_ON_APP_OPEN");
            }
            this.schedulePeriodicFlushIfRequired();
            MoEDTManager.getInstance().forceSyncDeviceTriggers(this.context);
            this.updateFeatureConfigForOptOutIfRequired();
            MiPushManager.getInstance().initMiPush(MoEHelper.getInstance(this.context).getApplication());
        }
        catch (Exception e) {
            Logger.f("MoEDispatcher: onAppOpen() ", e);
        }
    }

    void updateFeatureConfigForOptOutIfRequired() {
        ConfigurationProvider provider = ConfigurationProvider.getInstance(this.context);
        if (provider.isDataTrackingOptedOut()) {
            provider.optOutOfAdIdCollection(true);
            provider.optOutOfAndroidIdCollection(true);
            provider.optOutOfTrackLocation(true);
            provider.optOutOfSetGeoFence(true);
            provider.optOutOfDeviceAttributesCollection(true);
            provider.setLocationServicesState(false);
        }
        if (provider.isPushNotificationOptedOut()) {
            provider.clearPushToken();
        }
    }

    public void setOnLogoutCompleteListener(OnLogoutCompleteListener listener) {
        this.logoutCompleteListener = listener;
    }

    public void removeOnLogoutCompleteListener() {
        this.logoutCompleteListener = null;
    }

    private void notifyLogoutCompleteListener() {
        Logger.v("MoEDispatcher notifyLogoutCompleteListener() : Notifying listeners");
        if (this.logoutCompleteListener != null) {
            this.logoutCompleteListener.logoutComplete();
        }
    }

    void onAppClose() {
        Logger.v("MoEDispatcher onAppClose(): Application going to background.");
        this.notifyOnAppBackground();
        this.getDeviceAddManager().retryDeviceRegistrationIfRequired(this.context);
        this.shutDownPeriodicFlush();
        InAppController.getInstance().writeInAppCheckFailureCounterToStorage(this.context);
        MoEDTManager.getInstance().scheduleBackgroundSync(this.context);
        this.configProvider.saveSentScreenNames(ConfigurationCache.getInstance().getSentScreenNames());
        PushAmpManager.getInstance().scheduleServerSync(this.context);
        this.trackAppExit();
        AnalyticsHelper.getInstance(this.context).onAppClose(this.context);
    }

    private void notifyOnAppBackground() {
        OnAppBackgroundListener listener = MoEHelper.getInstance(this.context).getOnAppBackgroundListener();
        if (listener != null) {
            listener.goingToBackground();
        } else {
            Logger.v("MoEDispatcher execute() : on app background listener not set cannot provide callback");
        }
    }

    private void trackAppExit() {
        MoEHelper.getInstance(this.context).trackEvent("MOE_APP_EXIT", new PayloadBuilder());
    }

    public MoEAttributeManager getAttributeManager() {
        return this.attributeManager;
    }

    public DeviceAddManager getDeviceAddManager() {
        if (this.deviceAddManager == null) {
            this.deviceAddManager = new DeviceAddManager();
        }
        return this.deviceAddManager;
    }

    public MoECoreEvaluator getCoreEvaluator() {
        if (this.coreEvaluator == null) {
            this.coreEvaluator = new MoECoreEvaluator();
        }
        return this.coreEvaluator;
    }

    public ReportsBatchHelper getBatchHelper() {
        if (this.batchHelper == null) {
            this.batchHelper = new ReportsBatchHelper();
        }
        return this.batchHelper;
    }

    private boolean canAddTaskToQueue(ITask task) {
        if (!task.isSynchronous()) {
            return true;
        }
        return !this.runningTaskList.containsKey(task.getTaskTag());
    }

    private void onConfigApiSyncComplete(TaskResult taskResult) {
        if (taskResult == null || !taskResult.isSuccess()) {
            return;
        }
        if (MoEUtils.canEnableMiPush(ConfigurationCache.getInstance().getRemoteConfiguration())) {
            ConfigurationProvider.getInstance(this.context).savePushService("MI_PUSH");
            MiPushManager.getInstance().initMiPush(MoEHelper.getInstance(this.context).getApplication());
        } else {
            this.configProvider.saveMiPushToken("");
            this.configProvider.setMiTokenServerSentState(false);
            ConfigurationProvider.getInstance(this.context).savePushService("FCM");
        }
    }
}

