package com.moengage.core.model;

public class DevicePreferences {
  public final boolean isDataTrackingOptedOut;
  public final boolean isPushOptedOut;
  public final boolean isInAppOptedOut;

  public DevicePreferences(boolean isDataTrackingOptedOut, boolean isPushOptedOut,
      boolean isInAppOptedOut) {
    this.isDataTrackingOptedOut = isDataTrackingOptedOut;
    this.isPushOptedOut = isPushOptedOut;
    this.isInAppOptedOut = isInAppOptedOut;
  }

  @Override public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    DevicePreferences that = (DevicePreferences) o;

    if (isDataTrackingOptedOut != that.isDataTrackingOptedOut) return false;
    if (isPushOptedOut != that.isPushOptedOut) return false;
    return isInAppOptedOut == that.isInAppOptedOut;
  }

}