/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import android.util.Log;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.SendLogEntriesTask;
import com.moengage.core.executor.TaskProcessor;

public class Logger {
    public static final int VERBOSE = 5;
    public static final int DEBUG = 4;
    public static final int WARN = 3;
    public static final int ERROR = 2;
    public static final int INFO = 1;
    public static final int NO_LOGS = 0;
    private static int LOG_LEVEL = 2;
    private static Context mContext;
    private static final String TAG;
    private static boolean enableLogForSignedBuild;

    private Logger() {
    }

    public static void v(String msg) {
        if (Logger.isDebugEnabled() && LOG_LEVEL >= 5) {
            Log.v((String)TAG, (String)msg);
        }
    }

    public static void v(String msg, Throwable tr) {
        if (Logger.isDebugEnabled() && LOG_LEVEL >= 5) {
            Log.v((String)TAG, (String)msg, (Throwable)tr);
        }
    }

    public static void d(String msg) {
        if (Logger.isDebugEnabled() && LOG_LEVEL >= 4) {
            Log.d((String)TAG, (String)msg);
        }
    }

    public static void d(String msg, Throwable tr) {
        if (Logger.isDebugEnabled() && LOG_LEVEL >= 4) {
            Log.d((String)TAG, (String)msg, (Throwable)tr);
        }
    }

    public static void i(String msg) {
        if (Logger.isDebugEnabled() && LOG_LEVEL >= 1) {
            Log.i((String)TAG, (String)msg);
        }
    }

    public static void i(String msg, Throwable tr) {
        if (Logger.isDebugEnabled() && LOG_LEVEL >= 1) {
            Log.i((String)TAG, (String)msg, (Throwable)tr);
        }
    }

    public static void w(String msg) {
        if (Logger.isDebugEnabled() && LOG_LEVEL >= 3) {
            Log.w((String)TAG, (String)msg);
        }
    }

    public static void w(String msg, Throwable tr) {
        if (Logger.isDebugEnabled() && LOG_LEVEL >= 3) {
            Log.w((String)TAG, (String)msg, (Throwable)tr);
        }
    }

    public static void e(String msg) {
        if (Logger.isDebugEnabled() && LOG_LEVEL >= 2) {
            Log.e((String)TAG, (String)msg);
        }
    }

    public static void e(String msg, Throwable tr) {
        if (Logger.isDebugEnabled() && LOG_LEVEL >= 2) {
            Log.e((String)TAG, (String)msg, (Throwable)tr);
        }
    }

    public static void f(String msg) {
        if (mContext != null) {
            TaskProcessor.getInstance().addTask(new SendLogEntriesTask(mContext, msg, null, "error"));
        }
        if (Logger.isDebugEnabled() && LOG_LEVEL >= 2) {
            Log.e((String)TAG, (String)msg);
        }
    }

    public static void f(String msg, Throwable tr) {
        if (mContext != null) {
            TaskProcessor.getInstance().addTask(new SendLogEntriesTask(mContext, msg, tr, "error"));
        }
        if (Logger.isDebugEnabled() && LOG_LEVEL >= 2) {
            Log.e((String)TAG, (String)msg, (Throwable)tr);
        }
    }

    public static void setLogLevel(int logLevel) {
        LOG_LEVEL = logLevel;
    }

    static boolean isDebugEnabled() {
        return enableLogForSignedBuild;
    }

    public static void enableDebugLog(Context context) {
        if (null == context) {
            return;
        }
        try {
            boolean debugging = 0 != (context.getApplicationInfo().flags & 2);
            Logger.setLogStatus(debugging || ConfigurationProvider.getInstance(context).isDebugLogEnabled() || enableLogForSignedBuild);
            mContext = context;
        }
        catch (Exception e) {
            Logger.e("Logger : enableDebugLog", e);
        }
    }

    public static void setLogStatus(boolean value) {
        enableLogForSignedBuild = value;
    }

    static {
        TAG = "MoEngage_v9704";
        enableLogForSignedBuild = false;
    }
}

