/* ************************************************************************
 * 
 * MOENGAGE CONFIDENTIAL
 * __________________
 * 
 *  [2014] - [2015] MoEngage Inc. 
 *  All Rights Reserved.
 * 
 * NOTICE:  All information contained herein is, and remains
 * the property of MoEngage Inc. The intellectual and technical concepts
 * contained herein are proprietary to MoEngage Incorporated
 * and its suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from MoEngage Incorporated.
 */
package com.moe.pushlibrary;

import android.app.Activity;
import android.app.Application;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.location.Location;
import android.os.Build;
import android.os.Build.VERSION;
import android.os.Build.VERSION_CODES;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.annotation.RestrictTo.Scope;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.moe.pushlibrary.models.GeoLocation;
import com.moe.pushlibrary.utils.MoEHelperConstants;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.ConfigurationCache;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEDTManager;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.MoEUtils;
import com.moengage.core.MoEngage;
import com.moengage.core.MoEngage.Builder;
import com.moengage.core.MoEngage.DATA_REGION;
import com.moengage.core.events.MoEEventManager;
import com.moengage.core.integrations.segment.TrackSegmentEventTask;
import com.moengage.core.integrations.segment.TrackSegmentUserAttributeTask;
import com.moengage.core.listeners.OnAppBackgroundListener;
import com.moengage.core.listeners.OnLogoutCompleteListener;
import com.moengage.core.model.AppStatus;
import com.moengage.core.userattributes.MoEAttributeManager;
import com.moengage.inapp.InAppController;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

/**
 * Interaction class for MoEngage SDK. Has helper methods to track events and user attributes.
 *
 * @author MoEngage (abhishek@moengage.com)
 * @version 5.0
 * @since 1.0
 */
public class MoEHelper {

  /**
   * The entire task is delegated to the controller
   */
  private MoEDispatcher dispatcher = null;
  /**
   * Bundle extra which denotes that the activity was recreated for
   * configuration change and this should be accounted for when tracking
   */
  private String BUNDLE_EXTRA_RESTORING = "EXTRA_RESTORING";
  /**
   * Denotes that the activity is being restored from a previous state and it
   * should be tracked again for start
   */
  private boolean isActivityBeingRestored = false;
  /**
   * An instance of the application {@link Context}
   */
  private Context context;
  /**
   * Maintains the visible activity count
   */
  private static int activityCounter = 0;

  private static String TAG = "MoEHelper";

  private boolean isFirstScreen;

  public static int getActivityCounter(){
    return activityCounter;
  }

  /**
   * Increment the activity counter.
   */
  private static synchronized void incrementCounter() {
    activityCounter++;
  }

  /**
   * Decrement the activity counter.
   */
  private static synchronized void decrementCounter() {
    activityCounter--;
  }

  /**
   * Checks whether the app is in foreground or not.
   * If any screen is not being tracked then,
   * on that screen it would not return the correct value
   *
   * @return true if the app is in foreground else returns false
   */
  public static boolean isAppInForeground() {
    return activityCounter > 0;
  }

  private MoEAttributeManager attributeManager = null;

  /**
   * Instantiates an instance of {@link MoEHelper}.
   * Use {@link MoEHelper#getInstance(Context)}
   * @param con Reference to the Application {@link Context}
   */
  @Deprecated
  public MoEHelper(Context con) {
    context = con.getApplicationContext();
    if (null == dispatcher) {
      dispatcher = getDelegate();
    }
    attributeManager = getAttributeManager();
    instance = this;
  }

  /*
   * This is for backward porting the exposed API to reduce the number of
   * object created.
   */
  private static MoEHelper instance = null;

  /**
   * Returns a new Instance of {@link MoEHelper} for every call.
   *
   * @param con Application Context Reference. Should be a not NULL value
   * @return a new instance of MoEHelper
   */
  public static synchronized MoEHelper getInstance(Context con) {
    if (instance == null) {
      synchronized (MoEHelper.class){
       if (instance == null) instance = new MoEHelper(con);
      }
    }
    return instance;
  }

  /**
   * This method is deprecated use {@link MoEngage.Builder} instead of this method.
   */
  @Deprecated
  public void initialize(String senderId, String appId) {
    dispatcher.initialize(senderId, appId);
  }

	/* ********************** Activity call backs ************************** */

  /**
   * Integration point for on start of the {@link Activity} to which
   * {@link MoEHelper} is attached to.
   *
   * @param activity The current {@link Activity} to which this instance is
   * attached to
   * @param intent The new intent delivered to this activity
   */
  public void onNewIntent(Activity activity, Intent intent) {
    if(!isActivityBeingRestored){
      dispatcher.onStart(activity, intent);
    }
    InAppController.getInstance().registerInAppManager(activity);
  }

  /**
   * This method is deprecated use {@link MoEngage.Builder} instead of this method.
   * @deprecated 9.0.00
   */
  @Deprecated
  public void onStart(@NonNull Activity activity) {
    if(isAutoIntegration)return;
    onStartInternal(activity);
  }

  void onStartInternal(@NonNull Activity activity){
    if (getActivityCounter() == 0){
      dispatcher.onAppOpen();
      setFirstScreen(true);
    }
    incrementCounter();
    context = activity.getApplicationContext();
    onNewIntent(activity, null);
  }

  /**
   * This method is deprecated use {@link MoEngage.Builder} instead of this method.
   * @deprecated 9.0.00
   */
  @Deprecated
  public void onStop(@NonNull Activity activity){
    if(isAutoIntegration)return;
    onStopInternal(activity);
  }

  void onStopInternal(@NonNull Activity activity) {
    Logger.v("Activity onStop called for " + activity.toString());
    boolean configChange = MoEHelperUtils.isChangingConfiguration(activity);
    decrementCounter();
    InAppController.getInstance().unregisterInAppManager(activity);
    dispatcher.onStop(activity, configChange);
    String activityName = activity.getClass().getName();
  }

  /**
   * This method is deprecated use {@link MoEngage.Builder} instead of this method.
   */
  public void onResume(@NonNull Activity activity) {
    if(isAutoIntegration)return;
    onResumeInternal(activity);
  }

  void onResumeInternal(Activity activity){
    if (null == context) {
      context = activity.getApplicationContext();
    }
    Logger.v("Activity onResume called for " + activity.toString());
    dispatcher.onResume(activity, isActivityBeingRestored);
    isActivityBeingRestored = false;
  }

	/* ********************** Fragment call backs ************************** */

  /**
   * Fragment callback method for {@link Fragment#onStart()}
   *
   * @param activity The activity instance in which this {@link Fragment} is
   * visible
   * @param fragmentName The name of the fragment which is currently being started
   */
  public void onFragmentStart(Activity activity, String fragmentName) {
    dispatcher.onFragmentStart(activity, fragmentName);
  }

  /**
   * Fragment callback method for {@link Fragment#onStop()}
   *
   * @param activity The activity instance in which this {@link Fragment} is
   * visible
   * @param fragmentName The name of the fragment which is currently being stopped
   */
  public void onFragmentStop(Activity activity, String fragmentName) {
  }

	/* ********************** Handling config change ************************ */

  /**
   * Called to retrieve per-instance state from an activity before being
   * killed so that the activity is not tracked twice in MoEngage Platform.
   * Also helps to show the In App dialog even after the Configuration change
   *
   * @param outState Bundle in which to place your saved state.
   */
  public void onSaveInstanceState(Bundle outState) {
      Logger.v(TAG + " onSaveInstanceState-- saving state");
      if (null == outState) return;
      outState.putBoolean(BUNDLE_EXTRA_RESTORING, true);
   }

  /**
   * Called to restore the per instance state of the Activity so that it is
   * not tracked twice and also to restore the In App PromotionalMessage if it was being
   * shown before the configuration change occurred
   *
   * @param savedInstanceState the data most recently supplied in
   * {@link #onSaveInstanceState}.
   */
  public void onRestoreInstanceState(Bundle savedInstanceState) {
    Logger.v(TAG + " onRestoreInstanceState-- restoring state");
    if (null == savedInstanceState) return;
    if (savedInstanceState.containsKey(BUNDLE_EXTRA_RESTORING)) {
      isActivityBeingRestored = true;
      savedInstanceState.remove(BUNDLE_EXTRA_RESTORING);
    }
  }

  /**
   * Use {@link MoEHelper#trackEvent(String, PayloadBuilder)}
   */
  @Deprecated public MoEHelper trackEvent(@NonNull final String action, JSONObject attrs) {
    if (TextUtils.isEmpty(action)) return this;
    MoEEventManager.getInstance(context).trackEvent(action, attrs);
    return this;
  }

  /**
   * Use {@link MoEHelper#trackEvent(String, PayloadBuilder)}
   */
  @Deprecated
  public MoEHelper trackEvent(@NonNull final String action, @NonNull HashMap<String, String> attrs) {
    if(TextUtils.isEmpty(action))return this;
    Set<String> keySet = attrs.keySet();
    if (keySet.isEmpty()) {
      return this;
    }
    PayloadBuilder attributes = new PayloadBuilder();
    for (String key : keySet) {
      try {
        attributes.putAttrString(key, attrs.get(key));
      } catch (Exception e) {
        Logger.f(TAG + " trackEvent", e);
      }
    }
    trackEvent(action.trim(), attributes);
    return this;
  }

  /**
   * Use {@link MoEHelper#trackEvent(String, PayloadBuilder)}
   */
  @Deprecated
  public MoEHelper trackEvent(@NonNull final String action, @NonNull Map<String, String> attrs) {
    Set<String> keySet = attrs.keySet();
    if (keySet.isEmpty()) {
      return this;
    }
    PayloadBuilder newAttrs = new PayloadBuilder();
    for (String key : keySet) {
      try {
        newAttrs.putAttrString(key, attrs.get(key));
      } catch (Exception e) {
        Logger.f(TAG + " trackEvent", e);
      }
    }
    trackEvent(action, newAttrs);
    return this;
  }

  /**
   * Use {@link MoEHelper#trackEvent(String, PayloadBuilder)}
   */
  @Deprecated
  public MoEHelper trackEvent(@NonNull String action){
    if (TextUtils.isEmpty(action)) return this;
    trackEvent(action.trim(), new PayloadBuilder());
    return this;
  }

  public MoEHelper trackEvent(@NonNull String action, PayloadBuilder payloadBuilder) {
    if (TextUtils.isEmpty(action)) {
      Logger.e(TAG + " trackEvent() : Action name cannot be null");
      return this;
    }
    if (payloadBuilder == null) {
      payloadBuilder = new PayloadBuilder();
    } else {
      MoEEventManager.getInstance(context).trackEvent(action, payloadBuilder);
    }
    return this;
  }

  /**
   * Set an user attribute. This can be used to segment users on MoEngage
   * platform.
   *
   * @param userAttribute The user attribute name which needs to be added. This field
   * cannot be null
   * @param attributeValue The value associated with the specified user attribute
   * @return {@link MoEHelper} instance
   */
  public MoEHelper setUserAttribute(@NonNull String userAttribute, @NonNull String attributeValue) {
    if (userAttribute == null) {
      Logger.e(TAG + " User attribute value cannot be null");
      return this;
    }
    try {
      if (attributeValue == null) {
        attributeValue = "";
      } else if (MoEHelperConstants.USER_ATTRIBUTE_USER_BDAY.equals(userAttribute)) {
        attributeValue = URLEncoder.encode(attributeValue, "UTF-8");
      }
    } catch (UnsupportedEncodingException e1) {
      Logger.f(TAG + " setUserAttribute", e1);
    }catch (Exception e){
      Logger.f(TAG + " setUserAttribute", e);
    }
    JSONObject userJson = new JSONObject();
    try {
      userJson.put(userAttribute.trim(), attributeValue);
      attributeManager.setUserAttribute(userJson);
    } catch (Exception e) {
      Logger.f(TAG + " setUserAttribute", e);
    }
    return this;
  }

  /**
   * Set a user attribute for the current user
   *
   * @param userAttribute The attribute which needs to be set
   * @param attributeValue The attribute value corresponding to the userAttribute
   * @return {@link MoEHelper} instance
   */
  public MoEHelper setUserAttribute(@NonNull String userAttribute, int attributeValue) {
    if (userAttribute == null) {
      Logger.e(TAG + " User attribute value cannot be null");
      return this;
    }
    JSONObject userJson = new JSONObject();
    try {
      userJson.put(userAttribute.trim(), attributeValue);
      attributeManager.setUserAttribute(userJson);
    } catch (Exception e) {
      Logger.f(TAG + " setUserAttribute", e);
    }
    return this;
  }

  /**
   * Set a user attribute for the current user
   *
   * @param userAttribute The attribute which needs to be set
   * @param attributeValue The attribute value corresponding to the userAttribute
   * @return {@link MoEHelper} instance
   */
  public MoEHelper setUserAttribute(@NonNull String userAttribute, boolean
      attributeValue) {
    if (userAttribute == null) {
      Logger.e(TAG + " User attribute value cannot be null");
      return this;
    }
    JSONObject userJson = new JSONObject();
    try {
      userJson.put(userAttribute.trim(), attributeValue);
      attributeManager.setUserAttribute(userJson);
    } catch (Exception e) {
      Logger.f(TAG + " setUserAttribute", e);
    }
    return this;
  }

  /**
   * Set a user attribute for the current user
   *
   * @param userAttribute The attribute which needs to be set
   * @param attributeValue The attribute value corresponding to the userAttribute
   * @return {@link MoEHelper} instance
   */
  public MoEHelper setUserAttribute(@NonNull String userAttribute, double attributeValue) {
    if (userAttribute == null) {
      Logger.e(TAG + " User attribute value cannot be null");
      return this;
    }
    JSONObject userJson = new JSONObject();
    try {
      userJson.put(userAttribute.trim(), attributeValue);
      attributeManager.setUserAttribute(userJson);
    } catch (Exception e) {
      Logger.f(TAG + " setUserAttribute", e);
    }
    return this;
  }

  /**
   * Set a user attribute for the current user
   *
   * @param userAttribute The attribute which needs to be set
   * @param attributeValue The attribute value corresponding to the userAttribute
   * @return {@link MoEHelper} instance
   */
  public MoEHelper setUserAttribute(@NonNull String userAttribute, float attributeValue) {
    if (userAttribute == null) {
      Logger.e(TAG + " User attribute value cannot be null");
      return this;
    }
    JSONObject userJson = new JSONObject();
    try {
      userJson.put(userAttribute.trim(), attributeValue);
      attributeManager.setUserAttribute(userJson);
    } catch (Exception e) {
      Logger.f(TAG + " setUserAttribute", e);
    }
    return this;
  }

  /**
   * Set a user attribute for the current user
   *
   * @param userAttribute The attribute which needs to be set
   * @param attributeValue The attribute value corresponding to the userAttribute
   * @return {@link MoEHelper} instance
   */
  public MoEHelper setUserAttribute(@NonNull String userAttribute, long attributeValue) {
    if (userAttribute == null) {
      Logger.e(TAG + " User attribute value cannot be null");
      return this;
    }
    JSONObject userJson = new JSONObject();
    try {
      userJson.put(userAttribute.trim(), attributeValue);
      attributeManager.setUserAttribute(userJson);
    } catch (Exception e) {
      Logger.f(TAG + " setUserAttribute", e);
    }
    return this;
  }

  /**
   * Sets the given epoch time for the given user.
   *
   * @param userAttribute user attribute name
   * @param attributeValue user attribute value
   * @return {@link MoEHelper} instance
   */
  public MoEHelper setUserAttributeEpochTime(@NonNull String userAttribute, long attributeValue){
    if (userAttribute == null) {
      Logger.e(TAG + " User attribute value cannot be null");
      return this;
    }
    attributeManager.setCustomUserAttribute(new PayloadBuilder().putAttrDateEpoch(userAttribute,
        attributeValue).build());
    return this;
  }

  /**
   * Set the user attributes with the attributes specified in the HashMap
   *
   * @param attributeMap The attribute map which needs to be set for the user
   * @return {@link MoEHelper} instance
   */
  public MoEHelper setUserAttribute(@NonNull HashMap<String, Object> attributeMap) {
    if (attributeMap.isEmpty()) {
      Logger.e(TAG + " User attribute map cannot be null or empty");
      return this;
    }
    Set<String> keySet = attributeMap.keySet();
    if ( keySet.isEmpty() ) {
      return this;
    }
    for (String key : keySet) {
      try {
        if(TextUtils.isEmpty(key))continue;
        Object attrValue = attributeMap.get(key);
        if( attrValue instanceof Date){
          setUserAttribute(key.trim(), (Date)attrValue);
          continue;
        }else if( attrValue instanceof GeoLocation ){
          setUserAttribute(key.trim(), (GeoLocation)attrValue);
          continue;
        }else if( attrValue instanceof Location ){
          setUserAttribute(key.trim(), (Location)attrValue);
          continue;
        }
        JSONObject userJson = new JSONObject();
        userJson.put(key.trim(), attrValue);
        attributeManager.setUserAttribute(userJson);
      } catch (Exception e) {
        Logger.f(TAG + " setUserAttribute", e);
      }
    }
    return this;
  }

  /**
   * Set the user attributes with the attributes specified in the HashMap
   *
   * @param attributeMap The attribute map which needs to be set for the user
   * @return {@link MoEHelper} instance
   */
  public MoEHelper setUserAttribute(@NonNull Map<String, Object> attributeMap) {
    if (attributeMap.isEmpty()) {
      Logger.e(TAG + " User attribute map cannot be null or empty");
      return this;
    }
    Set<String> keySet = attributeMap.keySet();
    if ( keySet.isEmpty() ) {
      return this;
    }
    for (String key : keySet) {
      try {
        if(TextUtils.isEmpty(key))continue;
        Object attrValue = attributeMap.get(key);
        if( attrValue instanceof Date){
          setUserAttribute(key.trim(), (Date)attrValue);
          continue;
        }else if( attrValue instanceof GeoLocation ){
          setUserAttribute(key.trim(), (GeoLocation)attrValue);
          continue;
        }else if( attrValue instanceof Location ){
          setUserAttribute(key.trim(), (Location)attrValue);
          continue;
        }
        JSONObject userJson = new JSONObject();
        userJson.put(key.trim(), attrValue);
        attributeManager.setUserAttribute(userJson);
      } catch (Exception e) {
        Logger.f(TAG + " setUserAttribute", e);
      }
    }
    return this;
  }

  /**
   * Set a date user attribute for the current user.
   *
   * @param name user attribute name.
   * @param value user attribute value.
   * @return {@link MoEHelper} instance
   */
  public MoEHelper setUserAttribute(@NonNull String name, @NonNull Date value){
    if (name == null) {
      Logger.e(TAG + " User attribute value cannot be null");
      return this;
    }
    attributeManager.setCustomUserAttribute(new PayloadBuilder().putAttrDate(name, value).build());
    return this;
  }

  public MoEHelper setUserAttribute(@NonNull String name, @NonNull String date, String dateFormat){
    if (name == null) {
      Logger.e(TAG + " User attribute value cannot be null");
      return this;
    }
    attributeManager.setCustomUserAttribute(new PayloadBuilder().putAttrDate(name, date, dateFormat).build());
    return this;
  }

  public MoEHelper setUserAttribute(@NonNull String name, @NonNull Location location){
    if (name == null) {
      Logger.e(TAG + " User attribute value cannot be null");
      return this;
    }
    attributeManager.setCustomUserAttribute(new PayloadBuilder().putAttrLocation(name, location).build());
    return this;
  }

  public MoEHelper setUserAttribute(@NonNull String name, @NonNull GeoLocation location){
    if (name == null) {
      Logger.e(TAG + " User attribute value cannot be null");
      return this;
    }
    attributeManager.setCustomUserAttribute(new PayloadBuilder().putAttrLocation(name, location).build());
    return this;
  }

  /**
   * To set user location, call this method
   *
   * @param lat The latitude of the user location
   * @param lng The longitude of the user location
   */
  public void setUserLocation(double lat, double lng) {
    setUserAttribute(MoEHelperConstants.USER_ATTRIBUTE_USER_LOCATION, new GeoLocation(lat, lng));
  }

  /**
   * Returns the Inbox unread message count Don't call on main thread
   *
   * @return The count of unread messages
   */
  @WorkerThread
  public int getUnreadMessagesCount() {
    return dispatcher.getUnreadMessageCount();
  }

  /**
   * <b>Advanced API not required for general usage.</b> Forces the SDK to
   * fetch in app messages from the server. This method does not need to be
   * called explicitly because the SDK periodically synchronizes data with the
   * server.
   * @param force force to show inapps
   */
  public void showInAppIfAny(boolean force) {
    dispatcher.checkForInAppMessages(force);
  }

  /**
   * Use{@link MoEHelper#setAppStatus(AppStatus)}
   */
  @Deprecated
  public void setExistingUser(boolean existingUser) {
    dispatcher.setExistingUser(existingUser);
  }
	/* ***** Client call backs ***** */

	/* ************************************************************************* */

  /**
   * Retrieves all Inbox messages from the DB<br>
   * <b>Note : Don't call on UI Thread</b>.
   * @param context An instance of the application {@link Context}
   * @return A {@link Cursor} with all the existing messages
   */
  @Nullable @WorkerThread
  public static Cursor getAllMessages(Context context) {
    return MoEDispatcher.getInstance(context).getAllMessages();
  }

  /**
   * Logs that the message with the provided id was clicked
   *
   * @param context An instance of the application {@link Context}
   * @param id The id associated with the message which was clicked
   */
  @WorkerThread
  public static void setMessageClicked(Context context, long id) {
    MoEDispatcher.getInstance(context).setInboxMessageClicked(id);
  }

  /**
   * Invalidates the existing sessions and user attributes and treats all
   * actions performed by the user as a new user after this method is called<br>
   * If the Application is doing a self registration for gcm token then invalidate the token on
   * logout
   */
  public void logoutUser() {
    if (null == context) return;
    dispatcher.logoutUser(false);
  }

  /**
   * Will request a data sync with MoEngage Platform.
   */
  public void syncInteractionDataNow() {
    dispatcher.sendInteractionData();
  }

  /**
   * Set the notification time preference which will be kept into account
   * when notifications are being sent from the MoEngage Platform
   *
   * @param dontSendStart The Do Not Disturb Start Time
   * @param dontSendEnd The Do Not Disturb End Time
   * @param format The time format being used,
   * use any of these - hh:mm/hh:mm:ss
   * @param timezone The timezone in which the user is present.
   * The system expects IST, PST values
   */
  public void setNotificationPreference(String dontSendStart, String dontSendEnd, String timezone,
      String format) {
    try {
      JSONObject obj = new JSONObject();
      obj.put(MoEHelperConstants.USER_ATTRIBUTE_NOTIFICATION_START, dontSendStart);
      obj.put(MoEHelperConstants.USER_ATTRIBUTE_NOTIFICATION_END, dontSendEnd);
      obj.put(MoEHelperConstants.USER_ATTRIBUTE_ASSOCIATED_TIMEZONE, timezone);
      obj.put(MoEHelperConstants.USER_ATTRIBUTE_ASSOCIATED_TIME_FORMAT, format);
      JSONObject userAttrObj = new JSONObject();
      userAttrObj.put(MoEHelperConstants.USER_ATTRIBUTE_NOTIFICATION_PREF, obj.toString());
      attributeManager.setUserAttribute(userAttrObj);
    } catch (Exception e) {
      Logger.f(TAG + " setNotificationPreference", e);
    }
  }

  /**
   * This API is deprecated user {@link Builder#optOutGAIDCollection()}
   * @deprecated 9.0.00
   */
  @Deprecated public void optOutOfAdIdCollection(Context context, boolean optOut) {
    ConfigurationProvider.getInstance(context).optOutOfAdIdCollection(optOut);
  }

  /**
   * This API is deprecated use {@link Builder#optOutLocationTracking()}
   * @deprecated 9.0.00
   */
  @Deprecated public void optOutOfLocationTracking(boolean optOut) {
    ConfigurationProvider.getInstance(context).optOutOfTrackLocation(optOut);
  }

  /**
   * This API is deprecated use {@link Builder#optOutGeoFence()}
   * @deprecated 9.0.00
   */
  @Deprecated public void optOutOfGeoFences(boolean optOut) {
    ConfigurationProvider.getInstance(context).optOutOfSetGeoFence(optOut);
  }

  public void trackNotificationClickedByTime(long gtime){
    dispatcher.trackNotificationClicked(gtime);
  }

  public void playNotificationSound(boolean state){
    ConfigurationProvider.getInstance(context).saveNotificationSoundState(state);
  }

  /**
   * This API is deprecated use {@link Builder(Application)} <br>.
   * @deprecated 9.0.00
   */
  @Deprecated public void autoIntegrate(Application application) {
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.ICE_CREAM_SANDWICH) {

      Logger.d("MoEHelper: Auto integration is enabled");
      if (application == null){
        Logger.e( TAG + " autoIntegrate() : Cannot resiter for lifecycle callbacks. Application "
            + "instance is null.");
        return;
      }
      this.application = application;
      if (lifeCycleCallBacks == null){
        lifeCycleCallBacks = new MoEActivityLifeCycleCallBacks();
        application.registerActivityLifecycleCallbacks(lifeCycleCallBacks);
        isAutoIntegration = true;
      }
    }
  }

  private static boolean isAutoIntegration = false;

  private MoEActivityLifeCycleCallBacks lifeCycleCallBacks;

  /**
   * Method to unregister lifecycle callbacks
   * @param application reference to {@link Application}
   */
  public void unregisterLifecycleCallbacks(@NonNull Application application){
    if (VERSION.SDK_INT >= VERSION_CODES.ICE_CREAM_SANDWICH){
      Logger.v( "MoEHelper unregisterLifecycleCallbacks() : will try to unregister lifecycle "
          + "callbacks");
      if (lifeCycleCallBacks != null && application != null){
        Logger.v(TAG + " unregisterLifecycleCallbacks() : un-registering for lifecycle callbacks");
        application.unregisterActivityLifecycleCallbacks(lifeCycleCallBacks);
        isAutoIntegration = false;
      }else {
        Logger.v(TAG + " unregisterLifecycleCallbacks() : either lifecycle callbacks or "
            + "application class instance is null cannot unregister.");
      }
    }
  }


  public MoEDispatcher getDelegate(){
    if( null == dispatcher){
      dispatcher = MoEDispatcher.getInstance(context);
    }
    return dispatcher;
  }

  /**
   * Helper method to set user email
   *
   * @param value email of User passed by user
   */
  public void setEmail(@NonNull String value) {
      setUserAttribute(MoEHelperConstants.USER_ATTRIBUTE_USER_EMAIL, value);
  }

  /**
   * Helper method to set user full name
   *
   * @param value Full Name of user passed by user
   */
  public void setFullName(@NonNull String value) {
      setUserAttribute(MoEHelperConstants.USER_ATTRIBUTE_USER_NAME, value);
  }

  /**
   * Helper method to set user gender
   *
   * @param value Gender value passed by user
   */
  public void setGender(@NonNull String value) {
      setUserAttribute(MoEHelperConstants.USER_ATTRIBUTE_USER_GENDER, value);
  }

  /**
   * Helper method to set User first Name
   *
   * @param value First Name value passed by user
   */
  public void setFirstName(@NonNull String value) {
      setUserAttribute(MoEHelperConstants.USER_ATTRIBUTE_USER_FIRST_NAME, value);
  }

  /**
   * Helper method to set User Last Name
   *
   * @param value Last Name value passed by user
   */
  public void setLastName(@NonNull String value) {
      setUserAttribute(MoEHelperConstants.USER_ATTRIBUTE_USER_LAST_NAME, value);
  }

  /**
   * Helper method to set User BirthDate
   * Use {@link MoEHelper#setBirthDate(Date)}
   * @param value BirthDate value passed by user
   */
  @Deprecated
  public void setBirthDate(@NonNull String value) {
      setUserAttribute(MoEHelperConstants.USER_ATTRIBUTE_USER_BDAY, value);
  }

  /**
   * Helper method to set User BirthDate<br>
   *
   * @param birthDate BirthDate value passed by user
   */
  public void setBirthDate(@NonNull Date birthDate){
    attributeManager.setCustomUserAttribute(new PayloadBuilder().putAttrDate(MoEHelperConstants
        .USER_ATTRIBUTE_USER_BDAY, birthDate).build());
  }

  /**
   * Helper method to set User Unique Id
   *
   * @param value Unique Id passed by Client
   */
  public void setUniqueId(@NonNull String value) {
    if (MoEUtils.isEmptyString(value)){
      Logger.e( TAG + " setUniqueId() : Cannot set null unique id.");
      return;
    }
    setUserAttribute(MoEHelperConstants.USER_ATTRIBUTE_UNIQUE_ID, value);
  }

  /**
   * Helper method to set User Unique Id
   *
   * @param value Unique Id passed by Client
   */
  public void setUniqueId(int value) {
    setUserAttribute(MoEHelperConstants.USER_ATTRIBUTE_UNIQUE_ID, value);
  }

  /**
   * Helper method to set User Unique Id
   *
   * @param value Unique Id passed by Client
   */
  public void setUniqueId(long value) {
    setUserAttribute(MoEHelperConstants.USER_ATTRIBUTE_UNIQUE_ID, value);
  }

  /**
   * Helper method to set User Unique Id
   *
   * @param value Unique Id passed by Client
   */
  public void setUniqueId(float value) {
    setUserAttribute(MoEHelperConstants.USER_ATTRIBUTE_UNIQUE_ID, value);
  }

  /**
   * Helper method to set User Unique Id
   *
   * @param value Unique Id passed by Client
   */
  public void setUniqueId(double value) {
    setUserAttribute(MoEHelperConstants.USER_ATTRIBUTE_UNIQUE_ID, value);
  }

  /**
   * Helper method to set User Number
   *
   * @param value Number passed by user
   */
  public void setNumber(String value) {
    if (!TextUtils.isEmpty(value)) {
      setUserAttribute(MoEHelperConstants.USER_ATTRIBUTE_USER_MOBILE, value);
    }
  }

  /**
   * This API is deprecated use {@link MoEngage.Builder#setLogLevel(int)}
   * @deprecated 9.0.00
   */
  @Deprecated public void setLogLevel(int logLevel) {
    Logger.setLogLevel(logLevel);
  }

  /**
   * This API is deprecated use {@link Builder#enableLogsForSignedBuild()}
   * @deprecated 9.0.00
   */
  @Deprecated public void setLogStatus(boolean status) {
    Logger.setLogStatus(status);
  }

  /**
   * This API is deprecated use {@link Builder#optOutAndroidIdCollection()}
   * @deprecated 9.0.00
   */
  @Deprecated public void optOutOfAndroidIdCollection(@NonNull Context context, boolean optOut) {
    ConfigurationProvider.getInstance(context).optOutOfAndroidIdCollection(optOut);
  }

  /**
   * This API is deprecated use {@link Builder#optOutCarrierNameCollection()}
   * @deprecated 9.0.00
   */
  @Deprecated public void optOutOfOperatorNameCollection(@NonNull Context context, boolean optOut) {
    ConfigurationProvider.getInstance(context).optOutOfOperatorNameCollection(optOut);
  }

  /**
   * SDK does not collect IMEI any more.
   * @deprecated 9.0.00
   */
  @Deprecated public void optOutOfIMEICollection(@NonNull Context context, boolean optOut) {
  }

  /**
   * This API is deprecated use {@link Builder#optOutDeviceAttributeCollection()}
   * @deprecated 9.0.00
   */
  @Deprecated public void optOutOfDeviceAttributeCollection(@NonNull Context context,
      boolean optOut) {
    ConfigurationProvider.getInstance(context).optOutOfDeviceAttributesCollection(optOut);
  }

  /**
   * Tracks device locale.
   * Usage : Call the method in the application class of the application
   */
  public void trackDeviceLocale(){
    dispatcher.trackDeviceLocale();
  }

  public void setAlias(double currentId){
    try{
      JSONObject userJSON = new JSONObject();
      userJSON.put(MoEHelperConstants.USER_ATTRIBUTE_UNIQUE_ID, currentId);
      dispatcher.setAlias(userJSON);
    } catch(Exception e){
      Logger.f(TAG + " setAlias() ", e);
    }
  }

  /**
   * Update user's unique id which was previously set by {@link MoEHelper#setUniqueId(String)}
   * @param currentId updated unique id.
   */
  public void setAlias(String currentId){
    try{
      if (TextUtils.isEmpty(currentId)){
        Logger.e(TAG + "Updated id cannot be null");
        return;
      }
      JSONObject userJSON = new JSONObject();
      userJSON.put(MoEHelperConstants.USER_ATTRIBUTE_UNIQUE_ID, currentId.trim());
      dispatcher.setAlias(userJSON);
    } catch(Exception e){
      Logger.f(TAG + " setAlias() ", e);
    }
  }

  /**
   * Update user's unique id which was previously set by {@link MoEHelper#setUniqueId(long)}
   * @param currentId updated unique id.
   */
  public void setAlias(long currentId){
    try{
      JSONObject userJSON = new JSONObject();
      userJSON.put(MoEHelperConstants.USER_ATTRIBUTE_UNIQUE_ID, currentId);
      dispatcher.setAlias(userJSON);
    } catch(Exception e){
      Logger.f(TAG + " setAlias() ", e);
    }
  }

  /**
   * Update user's unique id which was previously set by {@link MoEHelper#setUniqueId(int)}
   * @param currentId updated unique id.
   */
  public void setAlias(int currentId) {
    try {
      JSONObject userJSON = new JSONObject();
      userJSON.put(MoEHelperConstants.USER_ATTRIBUTE_UNIQUE_ID, currentId);
      dispatcher.setAlias(userJSON);
    } catch (Exception e) {
      Logger.f(TAG + " setAlias() ", e);
    }
  }

  /**
   * Set push preference for the user.
   * @param pushPreference push preference value true or false
   */
  public void trackUserPushPreference(boolean pushPreference){
    setUserAttribute(MoEHelperConstants.USER_ATTRIBUTE_USER_PUSH_PREFERENCE, pushPreference);
  }

  /**
   * This method is deprecated use {@link MoEngage.Builder#redirectDataToRegion(DATA_REGION)}
   * @deprecated 9.0.00
   */
  @Deprecated
  public void redirectDataToRegion(int regionConstant){
    ConfigurationCache.getInstance().setMoEDataRegion(regionConstant);
  }

  private long flushInterval = -1;

  /**
   * This method is deprecated user {@link MoEngage.Builder#setFlushInterval(long)}
   * @deprecated 9.0.00
   */
  @Deprecated
  public void setFlushInterval(long flushInterval){
    long minimumFlushInterval =
        ConfigurationCache.getInstance().getRemoteConfiguration().getPeriodicFlushTime();
    if (flushInterval < minimumFlushInterval){
      Logger.e(TAG + " setFlushInterval() cannot set interval less than threshold. Threshold "
          + "value: " + minimumFlushInterval);
      return;
    }
    this.flushInterval = flushInterval;
  }

  public long getFlushInterval(){
    return flushInterval;
  }

  private boolean isPeriodicSyncEnabled = true;

  /**
   * This API is deprecated use {@link Builder#optOutPeriodicFlush()}
   * @deprecated 9.0.00
   */
  @Deprecated public void setPeriodicFlushState(boolean periodicFlushState) {
    isPeriodicSyncEnabled = periodicFlushState;
  }

  public boolean getPeriodicSyncState(){
    return isPeriodicSyncEnabled;
  }

  /**
   * Fetches device triggers
   *
   * @since 8.5.00
   */
  public void fetchDeviceTriggersIfRequired(){
    MoEDTManager.getInstance().syncDeviceTriggersIfRequired(context);
  }

  /**
   * Set a listener to be notified when logout is in progress.<br>
   * <b>Note:</b> Only one listener can be set.
   * @param listener instance of {@link OnLogoutCompleteListener}
   * @since 9.1.00
   */
  public void setOnLogoutCompleteListener(OnLogoutCompleteListener listener){
    dispatcher.setOnLogoutCompleteListener(listener);
  }

  /**
   * Remove the logout complete listener.
   * @since 9.1.00
   */
  public void removeLogoutCompleteListener(){
    dispatcher.removeOnLogoutCompleteListener();
  }

  public MoEHelper setUserAttributeISODate(@NonNull String attributeName, @NonNull String attributeValue) {
    dispatcher.setCustomUserAttribute(
        new PayloadBuilder().putAttrISO8601Date(attributeName, attributeValue).build());
    return this;
  }

  private OnAppBackgroundListener onAppBackgroundListener;

  public void registerAppBackgroundListener(OnAppBackgroundListener listener) {
    Logger.v(TAG + " registerAppBackgroundListener() : Registering OnAppBackgroundListener");
    onAppBackgroundListener = listener;
  }

  public void unregisterAppBackgroundListener() {
    Logger.v(TAG + " unregisterAppBackgroundListener() : Unregistering OnAppBackgroundListener");
    onAppBackgroundListener = null;
  }

  @Nullable public OnAppBackgroundListener getOnAppBackgroundListener() {
    return onAppBackgroundListener;
  }

  public MoEAttributeManager getAttributeManager(){
    return getDelegate().getAttributeManager();
  }

  /**
   * API to track event via MoEngage-Segment Bundled Integration.<br>
   * <b>Note:</b> Do not call this method. This is only for internal usage.
   *
   * @param eventName Event Name
   * @param eventAttributes Event Attributes
   * @since 9.4.02
   */
  public void trackEventFromSegment(String eventName, JSONObject eventAttributes) {
    getDelegate().addTaskToQueue(new TrackSegmentEventTask(context, eventName, eventAttributes));
  }

  /**
   * API to track user attributes via MoEngage-Segment Bundled Integration.<br>
   * <b>Note:</b> Do not call this method. This is only for internal usage.
   *
   * @param userAttributesMap attribute map.
   * @since 9.4.02
   */
  public void trackUserAttributeFromSegment(Map<String, Object> userAttributesMap) {
    getDelegate().addTaskToQueue(new TrackSegmentUserAttributeTask(context, userAttributesMap));
  }

  public boolean isFirstScreen(){
    return isFirstScreen;
  }

  @RestrictTo(Scope.LIBRARY)
  public void setFirstScreen(boolean firstScreen) {
    isFirstScreen = firstScreen;
  }

  public static boolean isAppInBackground() {
      return activityCounter <= 0;
    }

  private Application application;

  @Nullable
  public Application getApplication(){
    return application;
  }

  public void setApplication(Application application){
    this.application = application;
  }

  /**
   * This API tells the SDK whether it is a fresh install or an existing application was updated.
   *
   * @param status app status, either install or update.
   */
  public void setAppStatus(AppStatus status){
    if (status == AppStatus.INSTALL){
      getDelegate().setExistingUser(false);
    }else {
      getDelegate().setExistingUser(true);
    }
  }
}
