package com.moengage.core.remoteconfig;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.moengage.core.Logger;
import com.moengage.core.model.RemoteConfiguration;
import com.moengage.core.rest.Response;
import org.json.JSONObject;

/**
 * @author Umang Chamaria
 */
class RemoteConfigResponseParser {

  private static final String TAG = "RemoteConfigResponseParser";

  @Nullable RemoteConfiguration parseConfigApiResponse(Response response) {
    try {
      if (TextUtils.isEmpty(response.responseBody)) return null;
      JSONObject responseJson = new JSONObject(response.responseBody);
      return RemoteConfiguration.fromJson(responseJson);
    } catch (Exception e) {
      Logger.f(TAG + " parseConfigApiResponse() : Exception ", e);
    }
    return null;
  }
}
