/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.events;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import android.support.annotation.WorkerThread;
import com.moe.pushlibrary.MoEHelper;
import com.moe.pushlibrary.PayloadBuilder;
import com.moe.pushlibrary.models.Event;
import com.moengage.core.ConfigurationCache;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEDAO;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.events.EventHandler;
import com.moengage.core.events.TrackEventTask;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.json.JSONObject;

public class MoEEventManager {
    private static final String TAG = "MoEEventManager";
    private static MoEEventManager instance = null;
    private ConfigurationProvider configProvider = null;
    private Context context;
    private int eventCounter = 0;
    private List<String> inAppTriggerEvents;
    EventHandler eventHandler;

    private MoEEventManager(Context context) {
        this.context = context;
        this.configProvider = ConfigurationProvider.getInstance(context);
        this.getInAppSmartTriggerEvents();
        this.eventHandler = new EventHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MoEEventManager getInstance(Context context) {
        if (instance != null) return instance;
        Class<MoEEventManager> clazz = MoEEventManager.class;
        synchronized (MoEEventManager.class) {
            if (instance != null) return instance;
            instance = new MoEEventManager(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    int getEventCounter() {
        return this.eventCounter;
    }

    void incrementEventCounter() {
        ++this.eventCounter;
    }

    public void setEventCounter(int counter) {
        this.eventCounter = counter;
    }

    public void trackEvent(String action, JSONObject attributes) {
        this.trackEvent(this.eventHandler.transformToEventModel(action, attributes));
    }

    public void trackEvent(String action, PayloadBuilder attributes) {
        this.trackEvent(new Event(action, attributes.build()));
    }

    public void trackEvent(Event event) {
        if (!ConfigurationCache.getInstance().getRemoteConfiguration().isAppEnabled()) {
            return;
        }
        MoEDispatcher.getInstance(this.context).addTaskToQueue(new TrackEventTask(this.context, event));
    }

    boolean isSmartTriggerEvent(String action) {
        return this.inAppTriggerEvents != null && this.inAppTriggerEvents.contains(action) || "INSTALL".equals(action);
    }

    public void getInAppSmartTriggerEvents() {
        try {
            String list = this.configProvider.getSmartTriggerList();
            if (list == null) {
                Logger.v("MoEEventManager:No smart triggers found");
                return;
            }
            String[] triggers = list.split(";");
            this.inAppTriggerEvents = new ArrayList<String>(triggers.length);
            for (String event : triggers) {
                this.inAppTriggerEvents.add(event);
            }
        }
        catch (Exception e) {
            Logger.e("MoEEventManager: getInAppSmartTriggerEvents()", e);
        }
    }

    private boolean isFlushEvent(String eventName) {
        Set<String> flushEvents = ConfigurationCache.getInstance().getRemoteConfiguration().getFlushEventList();
        return flushEvents != null && flushEvents.contains(eventName);
    }

    void flushIfRequired(@NonNull Event event) {
        if (event.eventName != null && this.isFlushEvent(event.eventName)) {
            Logger.v("MoEEventManager flushIfRequired() flush event : " + event.eventName);
            MoEHelper.getInstance(this.context).syncInteractionDataNow();
        }
    }

    @WorkerThread
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void writeDataPointToStorage(Event event) {
        MoEDAO.getInstance(this.context).addEvent(event);
    }
}

