package com.moengage.core.model;

import android.support.annotation.Nullable;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map.Entry;
import java.util.Set;
import org.json.JSONObject;

/**
 * @author Umang Chamaria
 * Date: 2019-05-14
 */
public class TrafficSource {

  private static final String TAG = "TrafficSource";

  public TrafficSource(){
    extras = new HashMap<>();
  }

  @Nullable private String source;
  @Nullable private String medium;
  @Nullable private String campaignName;
  @Nullable private String campaignId;
  @Nullable private String sourceUrl;
  @Nullable private String content;
  @Nullable private String term;
  private HashMap<String, String> extras;

  @Nullable public String getSource() {
    return source;
  }

  public void setSource(@Nullable String source) {
    this.source = source;
  }

  @Nullable public String getMedium() {
    return medium;
  }

  public void setMedium(@Nullable String medium) {
    this.medium = medium;
  }

  @Nullable public String getCampaignName() {
    return campaignName;
  }

  public void setCampaignName(@Nullable String campaignName) {
    this.campaignName = campaignName;
  }

  @Nullable public String getCampaignId() {
    return campaignId;
  }

  public void setCampaignId(@Nullable String campaignId) {
    this.campaignId = campaignId;
  }

  @Nullable public String getSourceUrl() {
    return sourceUrl;
  }

  public void setSourceUrl(@Nullable String sourceUrl) {
    this.sourceUrl = sourceUrl;
  }

  @Nullable public String getContent() {
    return content;
  }

  public void setContent(@Nullable String content) {
    this.content = content;
  }

  @Nullable public String getTerm() {
    return term;
  }

  public void setTerm(@Nullable String term) {
    this.term = term;
  }

  public HashMap<String, String> getExtras() {
    return extras;
  }

  public void setExtras(HashMap<String, String> extras) {
    this.extras = extras;
  }

  @Nullable
  public static JSONObject toJson(TrafficSource source) {
    try {
      if (source == null) return null;
      JSONObject jsonObject = new JSONObject();
      if (source.getSource() != null){
        jsonObject.put(SOURCE, source.getSource());
      }
      if (source.getMedium() != null){
        jsonObject.put(MEDIUM, source.getMedium());
      }
      if (source.getCampaignName() != null){
        jsonObject.put(CAMPAIGN_NAME, source.getCampaignName());
      }
      if (source.getCampaignId() != null){
        jsonObject.put(CAMPAIGN_ID, source.getCampaignId());
      }
      if (source.getSourceUrl() != null){
        jsonObject.put(SOURCE_URL, source.getSourceUrl());
      }
      if (source.getContent() != null){
       jsonObject.put(CONTENT, source.getContent());
      }
      if (source.getTerm() != null){
        jsonObject.put(TERM, source.getTerm());
      }
      JSONObject extrasJson = new JSONObject();
      Set<Entry<String, String>> entrySet = source.getExtras().entrySet();
      for (Entry<String, String> entry: entrySet){
        extrasJson.put(entry.getKey(), entry.getValue());
      }
      if (extrasJson.length() > 0){
        jsonObject.put(EXTRAS, extrasJson);
      }
      return jsonObject;
    } catch (Exception e) {
      Logger.e( TAG + " toJson() : Exception ", e);
    }
    return null;
  }

  public static boolean isEmpty(TrafficSource source) {
    if (source == null) return true;
    return MoEUtils.isEmptyString(source.getSource())
        && MoEUtils.isEmptyString(source.getMedium())
        && MoEUtils.isEmptyString(source.getCampaignName())
        && MoEUtils.isEmptyString(source.getCampaignId())
        && MoEUtils.isEmptyString(source.getContent())
        && MoEUtils.isEmptyString(source.getTerm())
        && source.getExtras().isEmpty();
  }


  @Nullable public static TrafficSource fromJson(JSONObject sourceJson){
    try {
      TrafficSource source = new TrafficSource();
      source.setSource(sourceJson.optString(SOURCE, null));
      source.setMedium(sourceJson.optString(MEDIUM, null));
      source.setCampaignName(sourceJson.optString(CAMPAIGN_NAME, null));
      source.setCampaignId(sourceJson.optString(CAMPAIGN_ID, null));
      source.setSourceUrl(sourceJson.optString(SOURCE_URL, null));
      source.setContent(sourceJson.optString(CONTENT, null));
      source.setTerm(sourceJson.optString(TERM, null));
      if (sourceJson.has(EXTRAS)){
        JSONObject extrasJson = sourceJson.getJSONObject(EXTRAS);
        Iterator iterator = extrasJson.keys();
        HashMap<String, String> extras = new HashMap<>();
        while (iterator.hasNext()){
          String key = (String) iterator.next();
          String value = extrasJson.getString(key);
          extras.put(key, value);
        }
        source.setExtras(extras);
      }
      return source;
    }catch (Exception e){
      Logger.e( TAG + " fromJson() : Exception: ", e);
    }
    return null;
  }

  @Override public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    TrafficSource source1 = (TrafficSource) o;

    if (source != null ? !source.equals(source1.source) : source1.source != null) return false;
    if (medium != null ? !medium.equals(source1.medium) : source1.medium != null) return false;
    if (campaignName != null ? !campaignName.equals(source1.campaignName)
        : source1.campaignName != null) {
      return false;
    }
    if (campaignId != null ? !campaignId.equals(source1.campaignId) : source1.campaignId != null) {
      return false;
    }
/*    if (sourceUrl != null ? !sourceUrl.equals(source1.sourceUrl) : source1.sourceUrl != null) {
      return false;
    }*/
    if (content != null ? !content.equals(source1.content) : source1.content != null) return false;
    if (term != null ? !term.equals(source1.term) : source1.term != null) return false;
    return extras.equals(source1.extras);
  }

  @Override public String toString() {
    return "{" +
        "source : '" + source + '\'' +
        ", medium : '" + medium + '\'' +
        ", campaignName : '" + campaignName + '\'' +
        ", campaignId : '" + campaignId + '\'' +
        ", sourceUrl : '" + sourceUrl + '\'' +
        ", content : '" + content + '\'' +
        ", term : '" + term + '\'' +
        ", extras : " + extras.toString() +
        '}';
  }


  private static final String SOURCE = "source";
  private static final String MEDIUM = "medium";
  private static final String CAMPAIGN_NAME = "campaign_name";
  private static final String CAMPAIGN_ID = "campaign_id";
  private static final String SOURCE_URL = "source_url";
  private static final String CONTENT = "content";
  private static final String TERM = "term";
  private static final String EXTRAS = "extras";
}
