package com.moengage.core;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.moengage.core.rest.Response;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;

/**
 * @author Umang Chamaria
 */
public class ApiResponseUtility {
  private static final String TAG = "ApiResponseUtility";

  public static boolean isValidResponse(APIResponse response) {
    if (response == null) return false;
    if (response.responseCode != 200) return false;
    return response.responseBody != null;
  }

  @Nullable public static List<String> jsonArrayToStringList(JSONArray jsonArray) {
    try {
      if (jsonArray == null) return null;
      List<String> stringList = new ArrayList<>();
      for (int i = 0; i< jsonArray.length(); i++){
        String s = jsonArray.getString(i);
        if (!TextUtils.isEmpty(s)) {
          stringList.add(s);
        }
      }
      return stringList;
    } catch (Exception e) {
      Logger.f( TAG + " jsonArrayToStringList() : Exception ", e);
    }
    return null;
  }


  public static boolean isSuccessfulResponse(Response response) {
    if (response == null) return false;
    return response.responseCode == 200;
  }

  @Nullable public static Set<String> jsonArrayToStringSet(JSONArray jsonArray){
    try {
      if (jsonArray == null) return null;
      Set<String> stringSet = new HashSet<>(jsonArray.length());
      for (int i = 0; i < jsonArray.length(); i++) {
        if (!TextUtils.isEmpty(jsonArray.getString(i))) stringSet.add(jsonArray.getString(i));
      }
      return stringSet;
    }catch (Exception e){
      Logger.e( TAG + " jsonArrayToStringSet() : Exception: ", e);
    }
    return null;
  }
}
