package com.moengage.core;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.support.v4.app.TaskStackBuilder;
import android.telephony.PhoneNumberUtils;
import android.text.TextUtils;
import android.widget.Toast;
import com.delight.pushlibrary.R;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.ActionMapperConstants;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * @author Umang Chamaria
 */
public class ActionManagerBase {
  private static final String TAG = "ActionManagerBase";

  protected void handleActionCopy(Activity context, JSONObject actionObject) throws JSONException {
    Logger.v("ActionManagerBase$handleActionCopy");
    String message = "";
    if (actionObject.has(ActionMapperConstants.KEY_MESSAGE)) {
      message = actionObject.getString(ActionMapperConstants.KEY_MESSAGE);
    }
    if (actionObject.has(ActionMapperConstants.KEY_VALUE)) {
      String value = actionObject.getString(ActionMapperConstants.KEY_VALUE);
      MoEHelperUtils.copyCouponCodeToClipboard(context, value, message);
    }
  }

  protected void handleActionCall(Activity context, JSONObject actionObject) throws JSONException {
    Logger.v("ActionManagerBase$handleActionCall");
    if (actionObject.has(ActionMapperConstants.KEY_VALUE)) {
      String phoneNumber = actionObject.getString(ActionMapperConstants.KEY_VALUE);
      if (!TextUtils.isEmpty(phoneNumber) && isPhoneNumberValid(phoneNumber)) {
        Intent callIntent = new Intent(Intent.ACTION_DIAL);
        callIntent.setData(Uri.parse("tel:" + Uri.encode(phoneNumber)));
        context.startActivity(callIntent);
      } else {
        Toast.makeText(context, R.string.invalid_number, Toast.LENGTH_LONG).show();
      }
    }
  }

  protected void handleActionShare(Activity context, JSONObject actionObject) throws JSONException {
    Logger.v("ActionManagerBase$handleActionShare");
    Intent sharingIntent = new Intent(Intent.ACTION_SEND);
    if (actionObject.has(ActionMapperConstants.KEY_CONTENT)) {
      String content = actionObject.getString(ActionMapperConstants.KEY_CONTENT);
      sharingIntent.setType("text/plain");
      sharingIntent.putExtra(Intent.EXTRA_TEXT, content);
      context.startActivity(Intent.createChooser(sharingIntent, "Share via"));
    }
  }

  protected void handleActionNavigation(Activity context, JSONObject actionObject)
      throws JSONException, ClassNotFoundException {
    Logger.v("ActionManagerBase$handleActionNavigation");
    if (actionObject.has(ActionMapperConstants.KEY_SCREEN)) {
      String screenName = actionObject.getString(ActionMapperConstants.KEY_SCREEN);
      JSONObject extras = null;
      if (actionObject.has(ActionMapperConstants.KEY_EXTRA)) {
        extras = actionObject.getJSONObject(ActionMapperConstants.KEY_EXTRA);
      }
      Intent intent = new Intent(context, Class.forName(screenName));
      if (extras != null) {
        intent.putExtras(MoEHelperUtils.convertJSONObjecttoBundle(extras));
      }
      if (!ConfigurationCache.getInstance().isBackStackOptedOut()) {
        TaskStackBuilder builder = TaskStackBuilder.create(context);
        Logger.v(TAG + " handleActionNavigation() :synthesizing back stack ");
        // This activity is NOT part of this app's task, so create a new task
        // when navigating up, with a synthesized back stack.
        builder.addNextIntentWithParentStack(intent).startActivities();
      } else {
        context.startActivity(intent);
      }
    } else if (actionObject.has(ActionMapperConstants.KEY_URI)) {
      Uri link = Uri.parse(actionObject.getString(ActionMapperConstants.KEY_URI));
      Uri.Builder builder = link.buildUpon();
      Intent redirectIntent = new Intent(Intent.ACTION_VIEW, builder.build());
      context.startActivity(redirectIntent);
    }
  }

  private boolean isPhoneNumberValid(String phoneNumber){
    for (int i=0; i<phoneNumber.length(); i++){
      if (!PhoneNumberUtils.isDialable(phoneNumber.charAt(i))) return false;
    }
    return true;
  }

}
