/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import com.moengage.core.ConfigurationCache;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.model.RemoteConfiguration;
import java.util.Set;
import org.json.JSONObject;

public class LoadConfigurationFromDiskTask
extends SDKTask {
    private static final String TAG = "LoadConfigurationFromDiskTask";

    LoadConfigurationFromDiskTask(Context context) {
        super(context);
    }

    @Override
    public TaskResult execute() {
        this.loadRemoteConfigFromDisk();
        return null;
    }

    private void loadRemoteConfigFromDisk() {
        try {
            RemoteConfiguration storedConfig;
            String configurationString = ConfigurationProvider.getInstance(this.context).getRemoteConfiguration();
            RemoteConfiguration configuration = new RemoteConfiguration();
            if (configurationString != null && (storedConfig = RemoteConfiguration.fromJson(new JSONObject(configurationString))) != null) {
                configuration = storedConfig;
            }
            ConfigurationCache.getInstance().setRemoteConfiguration(configuration);
            Set<String> savedScreenNames = ConfigurationProvider.getInstance(this.context).getSentScreenNames();
            if (savedScreenNames != null) {
                ConfigurationCache.getInstance().initialiseSentScreens(savedScreenNames);
            }
            ConfigurationProvider.getInstance(this.context).loadInAppDelayDuration();
        }
        catch (Exception e) {
            Logger.e("LoadConfigurationFromDiskTask loadRemoteConfigFromDisk() : Exception ", e);
        }
    }

    @Override
    public String getTaskTag() {
        return "LOAD_CONFIGURATION_FROM_DISK";
    }

    @Override
    public boolean isSynchronous() {
        return true;
    }
}

