package com.moengage.core.events;

import android.content.Context;
import com.moe.pushlibrary.models.Event;
import com.moe.pushlibrary.utils.MoEHelperConstants;
import com.moengage.core.ConfigurationCache;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEDTManager;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.analytics.AnalyticsHelper;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.inapp.InAppController;

/**
 *
 * Tracks an event.
 * @author Umang Chamaria
 */
class TrackEventTask extends SDKTask {
  private static final String TAG = "TrackEventTask";

  private Event event;

  TrackEventTask(Context context, Event event) {
    super(context);
    this.event = event;
  }

  @Override public TaskResult execute() {
    try {
      Logger.v("TrackEventTask : executing task");
      if (event.eventName == null){
        Logger.e( TAG + " execute() : Event name is null cannot track it.");
        return null;
      }
      MoEEventManager eventManager = MoEEventManager.getInstance(context);
      ConfigurationCache cache = ConfigurationCache.getInstance();
      ConfigurationProvider configProvider = ConfigurationProvider.getInstance(context);
      // check for gdpr opt out and event blacklisting
      if (!eventManager.eventHandler.shouldTrackEvent(configProvider.isDataTrackingOptedOut(),
          cache.getRemoteConfiguration().getGdprWhitelistEventList(),
          cache.getRemoteConfiguration().getBlacklistedEventList(),
          event.eventName)){
        Logger.e( TAG + " execute() :  Either data tracking is opted out and this is not a GDPR "
            + "whitelist event cannot track or event is blacklisted Event Name: " + event.eventName);
        return taskResult;
      }
      // register install if required
      if (event.eventName.equals(MoEHelperConstants.EVENT_APP_INSTALL)) {
        ConfigurationProvider.getInstance(context).setInstallRegistered();
      }
      // check and show in-app smart trigger if required
      if (eventManager.isSmartTriggerEvent(event.eventName)) {
        // This is a smart action
        Logger.v("MoEEventManager:acting on auto trigger");
        InAppController.getInstance().registerAutoTriggerEvent(context, event);
      }
      // update session if required
      AnalyticsHelper.getInstance(context).onEventTracked(event, context);
      //check and show device triggers if possible
      MoEDTManager.getInstance().showTriggerIfPossible(context, event.eventName, event.attributes);
      // write event to storage
      eventManager.writeDataPointToStorage(event);
      // sync data points if required
      eventManager.flushIfRequired(event);
      // increment cached event counter
      MoEEventManager.getInstance(context).incrementEventCounter();
      Logger.v(TAG + " execute() : Cached event count: " + MoEEventManager.getInstance
          (context).getEventCounter());
      // update session info

      // immediate sync for unique id
      if(eventManager.getEventCounter() == ConfigurationCache.getInstance().getRemoteConfiguration().getEventBatchCount()){
        Logger.d("Unique Id set, So will try to send data");
        MoEDispatcher.getInstance(context).sendInteractionData();
      }
      Logger.v("TrackEventTask : completed execution");
    } catch (Exception e) {
      Logger.e( TAG + " execute() : Exception: ", e);
    }
    return null;
  }

  @Override public String getTaskTag() {
    return TAG_TRACK_EVENT;
  }

  @Override public boolean isSynchronous() {
    return false;
  }
}
