package com.moengage.core;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.moe.pushlibrary.utils.MoEHelperConstants;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import org.json.JSONObject;

/**
 * @author Umang Chamaria
 */
class SendLogEntriesTask extends SDKTask {

  private static final String TAG = "SendLogEntriesTask";

  private String API = "https://webhook.logentries.com/noformat/logs/";
  private Throwable mThrowable;
  private String mErrorMessage;
  private String mErrorType;

  SendLogEntriesTask(Context context, String errorMessage, Throwable throwable, String errorType) {
    super(context);
    this.mThrowable = throwable;
    this.mErrorMessage = errorMessage;
    this.mErrorType = errorType;
  }

  @Override public TaskResult execute() {
    Logger.v("SendLogEntriesTask : executing Task");
    ConfigurationProvider provider = ConfigurationProvider.getInstance(context);
    if (provider == null) return null;
    try {
      if (!ConfigurationCache.getInstance().getRemoteConfiguration().isAppEnabled()
          || !ConfigurationCache.getInstance()
          .getRemoteConfiguration().isLogEntryEnabled()) return null;
      if (ConfigurationCache.getInstance().getRemoteConfiguration().isLogEntryEnabled()) {
        JSONObject logObject = new JSONObject();
        logObject.put("uid", provider.getCurrentUserId());
        logObject.put("appid", MoEUtils.getAppId(context));
        logObject.put("sdk_ver", MoEHelperConstants.LIB_VERSION);
        logObject.put("tm_s", System.currentTimeMillis());
        if (!TextUtils.isEmpty(mErrorType)) {
          logObject.put("|v|", mErrorType);
        }
        if (!TextUtils.isEmpty(mErrorMessage)) {
          logObject.put("msg", mErrorMessage);
        }
        String trace = Log.getStackTraceString(mThrowable);
        if (!TextUtils.isEmpty(trace)) {
          logObject.put("tb", trace);
        }
        String token = ConfigurationCache.getInstance().getRemoteConfiguration().getLogEntryToken();
        if (TextUtils.isEmpty(token)){
          Logger.e( TAG + " execute() : Log-entry token empty.");
          return null;
        }
        APIManager.uploadLogsToLogEntries(API + token, logObject);
      } else {
        Logger.v("SendLogEnteriesTask : LogEnteries disabled");
      }
    } catch (Exception e) {
      //intentionally left empty. will create a infinite recursive loop.
    }
    Logger.v("SendLogEntriesTask : execution completed");
    return null;
  }

  @Override public String getTaskTag() {
    return TAG_SEND_LOG;
  }

  @Override public boolean isSynchronous() {
    return false;
  }
}
