package com.moengage.core;

import android.annotation.TargetApi;
import android.app.job.JobParameters;
import android.app.job.JobService;
import android.os.Build.VERSION_CODES;

@TargetApi(VERSION_CODES.LOLLIPOP)
public class DataSyncJob extends JobService implements OnJobComplete{

  @Override public boolean onStartJob(JobParameters params){
    Logger.v("DataSyncJob: onStartJob");
    MoEDispatcher.getInstance(getApplicationContext()).sendInteractionData((OnJobComplete) this, params);
    return true;
  }

  @Override public boolean onStopJob(JobParameters params){
    return false;
  }

  @Override public void jobCompleted(JobParameters parameters, boolean needsReschedule) {
    try {
      Logger.v("DataSyncJob: jobCompleted() Job Completed will release lock");
      jobFinished(parameters, needsReschedule);
    } catch (Exception e) {
      Logger.f(  "DataSyncJob: jobCompleted() : Exception ", e);
    }
  }
}
