/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.userattributes;

import android.content.Context;
import com.moe.pushlibrary.models.Event;
import com.moengage.core.ConfigurationCache;
import com.moengage.core.Logger;
import com.moengage.core.MoEDAO;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.MoEUtils;
import com.moengage.core.events.MoEEventManager;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.model.MoEAttribute;
import org.json.JSONObject;

public class TrackAttributeTask
extends SDKTask {
    private static final String TAG = "TrackAttributeTask";
    private JSONObject attributeJson;
    private boolean isCustomAttribute;

    TrackAttributeTask(Context context, JSONObject attributeJson, boolean isCustomAttribute) {
        super(context);
        this.attributeJson = attributeJson;
        this.isCustomAttribute = isCustomAttribute;
    }

    @Override
    public TaskResult execute() {
        try {
            Logger.v("TrackAttributeTask executing Task : ");
            if (this.isCustomAttribute) {
                Logger.v("TrackAttributeTask execute() : No need to cache custom attributes, will track attribute.");
                this.writeUserAttributeToStorage(this.attributeJson);
                this.taskResult.setIsSuccess(true);
                return this.taskResult;
            }
            MoEAttribute trackedAttribute = MoEUtils.convertJsonToAttributeObject(this.attributeJson);
            if (trackedAttribute == null) {
                Logger.v("TrackAttributeTask execute() : Conversion from Json to object failed cannot decide whether to track attribute or not, will track attribute.");
                this.writeUserAttributeToStorage(this.attributeJson);
                this.taskResult.setIsSuccess(true);
                return this.taskResult;
            }
            Logger.v("TrackAttributeTask execute() : Will try to send attribute to server. Attribute: " + trackedAttribute.toString());
            MoEAttribute savedAttribute = MoEDAO.getInstance(this.context).getAttributeByName(trackedAttribute.getName());
            if (trackedAttribute.getName().equals("USER_ATTRIBUTE_UNIQUE_ID")) {
                if (!MoEDispatcher.getInstance(this.context).getCoreEvaluator().isValidUniqueId(ConfigurationCache.getInstance().getRemoteConfiguration().getBlockedUniqueIdRegex(), trackedAttribute.getValue())) {
                    Logger.e("TrackAttributeTask execute() : Not a valid unique id. tracked value: " + trackedAttribute.getValue());
                    this.taskResult.setIsSuccess(true);
                    return this.taskResult;
                }
                String currentUniqueId = MoEUtils.getUserAttributeUniqueId(this.context);
                if (currentUniqueId != null && !trackedAttribute.getValue().equals(currentUniqueId)) {
                    Logger.v("TrackAttributeTask execute(): User Attribute Unique Id has changed will trigger force logout.");
                    MoEDispatcher.getInstance(this.context).handleLogout(true);
                    return this.createTaskResult(this.attributeJson, false);
                }
                this.trackUserAttributeIfRequired(trackedAttribute, savedAttribute);
                this.taskResult.setIsSuccess(true);
                return this.taskResult;
            }
            trackedAttribute.setValue(MoEUtils.getSha1ForString(trackedAttribute.getValue()));
            if (savedAttribute != null) {
                Logger.v("TrackAttributeTask execute(): Saved user attribute: " + savedAttribute.toString());
            }
            this.trackUserAttributeIfRequired(trackedAttribute, savedAttribute);
            Logger.v("TrackAttributeTask execute() : completed execution");
        }
        catch (Exception e) {
            Logger.f("TrackAttributeTask execute() : Exception ", e);
        }
        this.taskResult.setIsSuccess(true);
        return this.taskResult;
    }

    private void trackUserAttributeIfRequired(MoEAttribute trackedAttribute, MoEAttribute savedAttribute) {
        if (this.shouldTrackAttribute(trackedAttribute, savedAttribute, ConfigurationCache.getInstance().getRemoteConfiguration().getUserAttributeCachingTime())) {
            this.writeUserAttributeToStorage(this.attributeJson);
            this.cacheAttribute(trackedAttribute);
        } else {
            Logger.v("TrackAttributeTask trackUserAttributeIfRequired() : Attribute Already tracked. Will not be sent to server.");
        }
    }

    @Override
    public String getTaskTag() {
        return "TRACK_ATTRIBUTE";
    }

    @Override
    public boolean isSynchronous() {
        return false;
    }

    private void writeUserAttributeToStorage(JSONObject attributeJson) {
        Event event = new Event("EVENT_ACTION_USER_ATTRIBUTE", attributeJson);
        MoEEventManager.getInstance(this.context).writeDataPointToStorage(event);
        this.syncIfRequired(event);
    }

    private void syncIfRequired(Event event) {
        if (event.details.contains("USER_ATTRIBUTE_UNIQUE_ID")) {
            Logger.v("TrackAttributeTasksyncIfRequired() Unique Id set, So will try to send data");
            MoEDispatcher.getInstance(this.context).sendInteractionData();
        }
    }

    private boolean shouldTrackAttribute(MoEAttribute trackedAttribute, MoEAttribute savedAttribute, long sendDelay) {
        if (savedAttribute == null || trackedAttribute == null) {
            return true;
        }
        if (!trackedAttribute.getName().equals(savedAttribute.getName())) {
            return true;
        }
        if (!trackedAttribute.getValue().equals(savedAttribute.getValue())) {
            return true;
        }
        if (!trackedAttribute.getDataType().equals(savedAttribute.getDataType())) {
            return true;
        }
        return savedAttribute.getLastTrackedTime() + sendDelay < trackedAttribute.getLastTrackedTime();
    }

    private void cacheAttribute(MoEAttribute attribute) {
        Logger.v("TrackAttributeTask cacheAttribute(): Will cache attribute: " + attribute.toString());
        if (attribute == null) {
            Logger.e("TrackAttributeTask cacheAttribute() : Attribute object is null cannot cache it.");
            return;
        }
        if (attribute.getName().equals("USER_ATTRIBUTE_UNIQUE_ID")) {
            Logger.v("TrackAttributeTask cacheAttribute(): Attribute to cache is USER_ATTRIBUTE_UNIQUE_ID will copy it to shared preference as well");
            MoEDAO.getInstance(this.context).saveUserAttributeUniqueId(attribute);
            return;
        }
        MoEDAO.getInstance(this.context).addOrUpdateAttributeToCache(attribute);
    }
}

