/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.app.Activity;
import android.text.TextUtils;
import com.moe.pushlibrary.MoEHelper;
import com.moengage.core.AdvertisingIdClient;
import com.moengage.core.ConfigurationCache;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEDAO;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.MoEUtils;
import com.moengage.core.analytics.AnalyticsHelper;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import java.util.List;

class ActivityStartTask
extends SDKTask {
    private static final String TAG = "ActivityStartTask";
    private Activity activity;

    ActivityStartTask(Activity activity) {
        super(activity.getApplicationContext());
        this.activity = activity;
    }

    @Override
    public TaskResult execute() {
        try {
            Logger.v("ActivityStartTask started execution");
            String activityName = this.activity.getClass().getName();
            Logger.v("ActivityLifecycleStart : " + activityName + " started");
            if (MoEHelper.getInstance(this.context).isFirstScreen()) {
                AnalyticsHelper.getInstance(this.context).onAppOpen(this.activity);
                this.trackActivityIfRequired(activityName);
                MoEDAO.getInstance(this.context).removeExpiredData();
                this.checkGoogleAdvertisementIDAndUpdate();
                MoEHelper.getInstance(this.context).setFirstScreen(false);
            } else {
                this.trackActivityIfRequired(activityName);
            }
            this.taskResult.setIsSuccess(true);
            Logger.v("ActivityStartTask completed execution");
        }
        catch (Exception e) {
            Logger.e("ActivityStartTask execute() : Exception: ", e);
        }
        return this.taskResult;
    }

    @Override
    public String getTaskTag() {
        return "START_ACTIVITY";
    }

    @Override
    public boolean isSynchronous() {
        return false;
    }

    private void checkGoogleAdvertisementIDAndUpdate() {
        ConfigurationProvider provider = ConfigurationProvider.getInstance(this.context);
        if (provider.isAdIdCollectionProhibitted()) {
            Logger.f("ActivityStartTask : Opted out of GAID Collection");
            return;
        }
        String storedGAID = provider.getStoredGAID();
        int storedISLAT = provider.getStoredISLAT();
        AdvertisingIdClient.AdInfo adInfo = MoEUtils.getAdvertisementInfo(this.context);
        if (adInfo == null) {
            return;
        }
        if (!(TextUtils.isEmpty((CharSequence)adInfo.getId()) || !TextUtils.isEmpty((CharSequence)storedGAID) && adInfo.getId().equals(storedGAID))) {
            MoEHelper.getInstance(this.context).setUserAttribute("MOE_GAID", adInfo.getId());
            provider.storeGAID(adInfo.getId());
        }
        if (adInfo.isLimitAdTrackingEnabled() != storedISLAT) {
            MoEHelper.getInstance(this.context).setUserAttribute("MOE_ISLAT", Integer.toString(adInfo.isLimitAdTrackingEnabled()));
            provider.storeISLAT(adInfo.isLimitAdTrackingEnabled());
        }
    }

    private boolean isActivityTracked(String activityName) {
        try {
            List<String> trackedScreen = ConfigurationProvider.getInstance(this.context).getSentScreenList();
            return trackedScreen != null && trackedScreen.contains(activityName);
        }
        catch (Exception e) {
            Logger.f("ActivityStartTask isActivityTracked() : ", e);
            return false;
        }
    }

    private void trackActivityIfRequired(String activityName) {
        if (!this.isActivityTracked(activityName) && MoEDispatcher.getInstance(this.context).getCoreEvaluator().shouldTrackScreenName(activityName, ConfigurationCache.getInstance().getActivityOptOutList())) {
            MoEUtils.trackActivityStates("EVENT_ACTION_ACTIVITY_START", activityName, this.context);
            ConfigurationProvider.getInstance(this.context).addScreenToSentList(activityName);
        }
    }
}

