package com.moengage.push;

import android.content.Context;
import android.support.annotation.Nullable;
import com.moengage.core.ConfigurationCache;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import org.json.JSONObject;

/**
 * @author Umang Chamaria
 */

public class MoEMessagingManager {

  private static MoEMessagingManager _INSTANCE = null;
  private MessagingHandler messagingHandler = null;

  private MoEMessagingManager() {
    loadHandler();
  }

  public static MoEMessagingManager getInstance(){
    if (_INSTANCE == null){
      _INSTANCE = new MoEMessagingManager();
    }
    return _INSTANCE;
  }

  private void loadHandler() {
    try {
      Class handler = Class.forName("com.moengage.addon.messaging.MessagingHandlerImpl");
      messagingHandler = (MessagingHandler) handler.newInstance();
      Logger.v("MoEMessagingManager:loadHandler Messaging module Enabled");
    } catch (Exception e) {
      Logger.e("MoEMessagingManager : loadHandler : did not find supported module: " + e.getMessage());
    }
  }

  @Nullable
  public MessagingHandler getMessagingHandler(Context context){
    ConfigurationProvider provider = ConfigurationProvider.getInstance(context);
    if (provider.isPushNotificationOptedOut() || !ConfigurationCache.getInstance()
        .getRemoteConfiguration()
        .isPushAmpEnabled()) {
      return null;
    }
    return messagingHandler;
  }

  public interface MessagingHandler {

    /**
     * Pulls pending notification from the server if sync is required.
     * @param context Application Context
     */
    void scheduleAndSyncMessages(Context context);

    /**
     * Parse the payload received from server and show notifications if required
     * @param context Application Context
     * @param payload Push Payload
     */
    void parsePayloadAndShowPush(Context context, JSONObject payload);

    /**
     * Immediately do a server sync
     * @param context Application Context
     * @param onAppOpen true if call is made on app open, else false
     */
    void forceMessageSync(Context context, boolean onAppOpen);

    /**
     * Schedule a message pull after a given time interval
     * @param context Application Context
     */
    void scheduleMessageSync(Context context);

    /**
     * Save campaign id in the local storage
     * @param context Application Context
     * @param campaignId Campaign Id to save
     */
    void saveCampaignId(Context context, String campaignId);

  }
}
