package com.moengage.core.mipush;

import android.app.Application;
import com.moe.pushlibrary.MoEHelper;
import com.moengage.core.ConfigurationCache;
import com.moengage.core.Logger;
import com.moengage.core.MoEConstants;
import com.moengage.core.MoEUtils;

/**
 * @author Umang Chamaria
 */
public class MiPushManager {

  private static final String TAG = "MiPushManager";

  private MiPushHandler miPushHandler;

  private static MiPushManager instance;

  private MiPushManager(){
    loadHandler();
  }

  private void loadHandler(){
    try {
      Class handler = Class.forName("com.moengage.mi.MiPushHandlerImpl");
      miPushHandler = (MiPushHandler) handler.newInstance();
    }catch (Exception e){
      Logger.e( TAG + " loadHandler() : Did not find Push Amp plus Module. ");
    }
  }

  public static MiPushManager getInstance(){
    if (instance == null){
      instance = new MiPushManager();
    }
    return instance;
  }

  public void initMiPush(Application application) {
    if (miPushHandler != null && MoEUtils.canEnableMiPush(
        ConfigurationCache.getInstance().getRemoteConfiguration())) {
      ConfigurationCache.getInstance().setPushService(MoEConstants.PUSH_SERVICE_MI_PUSH);
      miPushHandler.initMiPushIfRequired(MoEHelper.getInstance(application.getApplicationContext()).getApplication());
    }
  }

  public boolean hasMiPushModule(){
    return miPushHandler != null;
  }

}
