package com.moengage.core;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;

/**
 * @author Umang Chamaria
 */

public class MoEWorkerTask extends SDKTask {
  private String workerTaskType;
  private Bundle extras;
  public MoEWorkerTask(Context context, @NonNull String workerTaskType, @Nullable   Bundle extras) {
    super(context);
    this.workerTaskType = workerTaskType;
    this.extras = extras;
  }

  @Override public TaskResult execute() {
    try {
      Logger.v("MoEWorkerTask: executing task");
      if (TextUtils.isEmpty(workerTaskType)) return null;
      switch (workerTaskType) {
        case MoEConstants.SERVICE_TYPE_APP_UPDATE:
          MoEDispatcher.getInstance(context).handleAppUpdateEvent();
          break;
        case MoEConstants.SERVICE_TYPE_LOGOUT:
          boolean logoutType = false;
          if (extras != null && extras.containsKey(MoEConstants.SERVICE_LOGOUT_TYPE)){
            logoutType = extras.getBoolean(MoEConstants.SERVICE_LOGOUT_TYPE);
          }
          MoEDispatcher.getInstance(context).handleLogout(logoutType);
          break;
        default:
          Logger.e("Not a valid task type");
      }
      Logger.v("MoEWorkerTask: completed task");
    } catch (Exception e) {
      Logger.e("MoEWorkerTask: execute() ", e);
    }
    return null;
  }

  @Override public String getTaskTag() {
    return TAG_MOE_WORKER_TASK;
  }

  @Override public boolean isSynchronous() {
    return false;
  }
}
