/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.push;

import android.content.Context;
import android.support.annotation.Nullable;
import com.moengage.core.ConfigurationCache;
import com.moengage.core.Logger;
import com.moengage.push.PushHandler;
import com.moengage.push.TokenHandler;

public class PushManager {
    private static PushManager _INSTANCE = null;
    private PushHandler pushHandler;

    private PushManager() {
        this.loadPushHandler();
    }

    private void loadPushHandler() {
        try {
            if (!ConfigurationCache.getInstance().getBaiduPushState()) {
                try {
                    Class<?> handler = Class.forName("com.moengage.firebase.PushHandlerImpl");
                    this.pushHandler = (PushHandler)handler.newInstance();
                    Logger.v("PushManager:loadPushHandler FCM Enabled");
                }
                catch (Exception e) {
                    Class<?> handler = Class.forName("com.moengage.push.gcm.PushHandlerImpl");
                    this.pushHandler = (PushHandler)handler.newInstance();
                    Logger.v("PushManager:loadPushHandler GCM Enabled");
                }
            } else {
                Class<?> handler = Class.forName("com.moengage.baidu.PushHandlerImpl");
                this.pushHandler = (PushHandler)handler.newInstance();
                Logger.v("PushManager:loadPushHandler Baidu Enabled");
            }
        }
        catch (Exception e) {
            Logger.e("PushManager : loadPushHandler : did not find supported module: " + e.getMessage());
        }
    }

    public static PushManager getInstance() {
        if (null == _INSTANCE) {
            _INSTANCE = new PushManager();
        }
        return _INSTANCE;
    }

    public void setMessageListener(Object messageListener) {
        if (this.pushHandler != null) {
            this.pushHandler.setMessageListener(messageListener);
        }
    }

    public void refreshToken(Context context, String token) {
        TokenHandler.getInstance().processToken(context, token, "App");
    }

    @Nullable
    public PushHandler getPushHandler() {
        return this.pushHandler;
    }

    @Deprecated
    public final void optoutBackStackBuilder(Boolean value) {
        ConfigurationCache.getInstance().setBackStackOptOut(value);
    }

    public void setTokenObserver(OnTokenReceivedListener tokenObserver) {
        TokenHandler.getInstance().setTokenListener(tokenObserver);
    }

    @Deprecated
    public final void optOutMoEngageExtras(boolean value) {
        ConfigurationCache.getInstance().setExtrasOptOut(value);
    }

    public static interface OnTokenReceivedListener {
        public void onTokenReceived(String var1);
    }
}

