/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.moengage.core.APIResponse;
import com.moengage.core.Logger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;

public class ApiResponseUtility {
    private static final String TAG = "ApiResponseUtility";

    public static boolean isValidResponse(APIResponse response) {
        if (response == null) {
            return false;
        }
        if (response.responseCode != 200) {
            return false;
        }
        return response.responseBody != null;
    }

    @Nullable
    public static List<String> jsonArrayToStringList(JSONArray jsonArray) {
        try {
            if (jsonArray == null) {
                return null;
            }
            ArrayList<String> stringList = new ArrayList<String>();
            for (int i = 0; i < jsonArray.length(); ++i) {
                String s = jsonArray.getString(i);
                if (TextUtils.isEmpty((CharSequence)s)) continue;
                stringList.add(s);
            }
            return stringList;
        }
        catch (Exception e) {
            Logger.f("ApiResponseUtility jsonArrayToStringList() : Exception ", e);
            return null;
        }
    }

    @Nullable
    public static Set<String> jsonArrayToStringSet(JSONArray jsonArray) {
        try {
            if (jsonArray == null) {
                return null;
            }
            HashSet<String> stringSet = new HashSet<String>(jsonArray.length());
            for (int i = 0; i < jsonArray.length(); ++i) {
                if (TextUtils.isEmpty((CharSequence)jsonArray.getString(i))) continue;
                stringSet.add(jsonArray.getString(i));
            }
            return stringSet;
        }
        catch (Exception e) {
            Logger.e("ApiResponseUtility jsonArrayToStringSet() : Exception: ", e);
            return null;
        }
    }
}

