package com.moengage.core.model;

import android.support.annotation.Nullable;

/**
 * @author Umang Chamaria
 * Date: 2019-06-07
 */
public class ReportBatchMeta {

  @Nullable public final DevicePreferences preferences;
  public String batchId;
  public String requestTime;
  @Nullable public final UserSession userSession;
  public final boolean isDeviceAddPending;

  public ReportBatchMeta(@Nullable DevicePreferences preferences, String batchId, String requestTime) {
    this(preferences, batchId, requestTime, null, false);
  }

  public ReportBatchMeta(@Nullable DevicePreferences preferences, String batchId,
      String requestTime, @Nullable UserSession userSession, boolean isDeviceAddPending) {
    this.preferences = preferences;
    this.batchId = batchId;
    this.requestTime = requestTime;
    this.userSession = userSession;
    this.isDeviceAddPending = isDeviceAddPending;
  }

  @Override public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    ReportBatchMeta batchMeta = (ReportBatchMeta) o;

    if (preferences != null ? !preferences.equals(batchMeta.preferences)
        : batchMeta.preferences != null) {
      return false;
    }
    if (!batchId.equals(batchMeta.batchId)) return false;
    if (requestTime != null ? !requestTime.equals(batchMeta.requestTime):
        batchMeta.requestTime != null) return false;
    return userSession != null ? userSession.equals(batchMeta.userSession)
        : batchMeta.userSession == null;
  }

}
