package com.moengage.core;

import android.content.Context;
import android.support.annotation.NonNull;
import com.moe.pushlibrary.models.Event;
import com.moe.pushlibrary.models.UserAttribute;
import com.moengage.core.events.MoEEventManager;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import org.json.JSONObject;

/**
 * Track device attributes. This intentionally uses the user attribute table since there are very
 * device attributes as of now.
 *
 * @author Umang Chamaria
 */

class SetDeviceAttributeTask extends SDKTask{
  private static final String TAG = "SetDeviceAttributeTask";
  private JSONObject deviceAttribute;

  SetDeviceAttributeTask(@NonNull Context context, @NonNull JSONObject deviceAttribute){
    super(context);
    this.deviceAttribute = deviceAttribute;
  }

  @Override public TaskResult execute(){
    try {
      Logger.v("SetDeviceAttributeTask: executing Task");
      UserAttribute currentUserAttribute = MoEUtils.getUserAttributePoJo(deviceAttribute);
      UserAttribute savedUserAttribute = null;
      if (currentUserAttribute != null){
        savedUserAttribute =
            MoEUtils.getSavedUserAttribute(context, currentUserAttribute.userAttributeName);
      }
      if (MoEUtils.shouldSendUserAttribute(currentUserAttribute, savedUserAttribute)){
        Logger.d(
            "SetDeviceAttributeTask : setUserAttribute User attribute not yet sent to server will "
                + "send : "
                + deviceAttribute.toString());
        Event event = new Event(MoEConstants.EVENT_ACTION_DEVICE_ATTRIBUTE, deviceAttribute);
        MoEEventManager.getInstance(context).writeDataPointToStorage(event);
        MoEDAO.getInstance(context).addOrUpdateUserAttribute(currentUserAttribute);
        taskResult.setIsSuccess(true);
      } else{
        Logger.d(
            "SetDeviceAttributeTask : setUserAttributes already sent once, need not send duplicate "
                + "attribute : "
                + deviceAttribute.toString());
        taskResult.setIsSuccess(false);
      }
      Logger.v("SetDeviceAttributeTask: completed Task");
    } catch (Exception e) {
      Logger.e( TAG + " execute() : Exception: ", e);
    }
    return taskResult;
  }

  @Override public String getTaskTag(){
    return TAG_SET_DEVICE_ATTRIBUTES;
  }

  @Override public boolean isSynchronous(){
    return false;
  }
}
