package com.moengage.core;

import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.model.TrafficSource;
import java.util.List;
import java.util.regex.Pattern;
import org.json.JSONObject;

/**
 * @author Umang Chamaria
 */
public class MoECoreEvaluator {

  private static final String TAG = "MoECoreEvaluator";

  public boolean isValidUniqueId(List<String> uniqueIdRegexList, String trackedUniqueId) {
    try {
      if (uniqueIdRegexList == null) return true;
      for (String regex : uniqueIdRegexList) {
        if (Pattern.matches(regex, trackedUniqueId)) {
          return false;
        }
      }
    } catch (Exception e) {
      Logger.e(TAG + " isValidUniqueId() : Exception: ", e);
    }
    return true;
  }

  public boolean shouldTrackScreenName(String screenName, List<String> optedOutScreenNames) {
    return optedOutScreenNames != null
        && !optedOutScreenNames.isEmpty()
        && optedOutScreenNames.contains(screenName);
  }

  public boolean hasSessionExpired(long lastActiveTime, long sessionInActivityDuration,
      long currentTime) {
    return lastActiveTime + sessionInActivityDuration < currentTime;
  }

  public boolean hasSourceChanged(TrafficSource savedSource,
      TrafficSource currentSource) {
    if (TrafficSource.isEmpty(savedSource) && TrafficSource.isEmpty(currentSource)) return false;
    if (TrafficSource.isEmpty(savedSource) && !TrafficSource.isEmpty(currentSource)) return true;
    if (!TrafficSource.isEmpty(savedSource) && TrafficSource.isEmpty(currentSource)) return false;
    return !savedSource.equals(currentSource);
  }

  public boolean isInteractiveEvent(String dataPointString){
    try {
      JSONObject dataPointJson = new JSONObject(dataPointString);
      if (!dataPointJson.has(MoEHelperUtils.EVENT_NON_INTERACTIVE)) return true;
      int isInteractive = dataPointJson.getInt(MoEHelperUtils.EVENT_NON_INTERACTIVE);
      return isInteractive == 0;
    }catch (Exception e){
      Logger.e( TAG + " isInteractiveEvent() : Exception: ", e);
    }
    return true;
  }
}
