/* ************************************************************************
 * 
 * MOENGAGE CONFIDENTIAL
 * __________________
 * 
 *  [2014] - [2015] MoEngage Inc. 
 *  All Rights Reserved.
 * 
 * NOTICE:  All information contained herein is, and remains
 * the property of MoEngage Inc. The intellectual and technical concepts
 * contained herein are proprietary to MoEngage Incorporated
 * and its suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from MoEngage Incorporated.
 */
package com.moengage.core;

import android.Manifest;
import android.content.Context;
import android.net.Uri;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.moe.pushlibrary.exceptions.SDKNotInitializedException;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.MoERestClient.RequestMethod;
import com.moengage.core.rest.Request;
import com.moengage.core.rest.RequestBuilder;
import com.moengage.core.rest.RequestBuilder.RequestType;
import com.moengage.core.rest.Response;
import com.moengage.core.rest.RestClient;
import com.moengage.core.utils.RestUtils;
import com.moengage.inapp.InAppController;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.HashMap;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * This class is responsible for all interactions with the MoE servers.
 *
 * @author MoEngage (abhishek@moengage.com)
 * @version 5.0
 * @since 5.0
 */
public final class APIManager {

  private APIManager() {
    // Constructor intentionally made private. Utility class cannot be
    // instantiated
  }

  /*
   * @param con Instance of the Application {@link Context}
   * @param API API to trigger
   * @param paramsMap Body of API
   */
  @Nullable static String getGeoFences(Context con, String API,
      HashMap<String, String> paramsMap) {
    Logger.v("APIManager: getGeoFences: Get geo fences");
    if ((MoEHelperUtils.hasPermission(con, Manifest.permission.ACCESS_FINE_LOCATION)
        || MoEHelperUtils.hasPermission(con, Manifest.permission.ACCESS_COARSE_LOCATION))) {
      try {
        if (!ConfigurationCache.getInstance().getRemoteConfiguration().isAppEnabled() || !ConfigurationCache
            .getInstance().getRemoteConfiguration().isGeofenceEnabled()) return null;
        MoERestClient client = new MoERestClient(API, con);
        client.addParam(paramsMap);
        client.execute(MoERestClient.RequestMethod.POST);
        if (!isHttpStatusOk(client.getResponseCode())) {
          return null;
        }
        if (isValidAPIResponse(client.getResponse())) {
          return client.getResponse();
        }
      } catch (UnsupportedEncodingException e) {
        Logger.f("APIManager: getGeoFences", e);
      } catch (Exception e) {
        Logger.f("APIManager: getGeoFences", e);
      }
    }
    return null;
  }

  /*
   * @param con Instance of the Application {@link Context}
   */
  static void geoFenceHit(Context con, String API, HashMap<String, String> paramsMap) {
    Logger.v("APIManager:Registering a Geofence hit");
    try {
      if (!ConfigurationCache.getInstance().getRemoteConfiguration().isAppEnabled() || !ConfigurationCache
          .getInstance().getRemoteConfiguration().isGeofenceEnabled()) return;
      MoERestClient client = new MoERestClient(API, con);
      client.addParam(paramsMap);
      client.execute(MoERestClient.RequestMethod.POST);
    } catch (UnsupportedEncodingException e) {
      Logger.f("APIManager: geoFenceHit", e);
    } catch (IOException e) {
      Logger.f("APIManager: geoFenceHit", e);
    } catch (SDKNotInitializedException e) {
      Logger.f("APIManager: geoFenceHit", e);
    } catch (Exception e) {
      Logger.f("APIManager: geoFenceHit", e);
    }
  }

  /*
   * @param con Instance of the Application {@link Context}
   * @param paramsMap The last updated time for the local inapp cache
   * @param API API to trigger
   * @param requestBody Request Body
   * @return true if the fetch was successful
   */
  @Nullable static String fetchInAppCampaigns(Context con, String API,
      HashMap<String, String> paramsMap, JSONObject requestBody) {
    try {
      if (!ConfigurationCache.getInstance().getRemoteConfiguration().isAppEnabled() || !ConfigurationCache.getInstance()
          .getRemoteConfiguration().isInAppEnabled()) return null;
      MoERestClient client = new MoERestClient(API, con);
      client.addParam(paramsMap);
      if (requestBody != null){
        client.addBody(requestBody);
      }
      client.execute(RequestMethod.POST);
      Logger.v("APIManager: Processing InApp Response - will parse and save data");
      if (!isHttpStatusOk(client.getResponseCode())) {
        InAppController.getInstance().trackAPIFailure(InAppController.SYNC_API_FAILURE);
        return null;
      }
      //update last updated time
      ConfigurationProvider.getInstance(con).setLastInappUpdateTime(System.currentTimeMillis());
      if (!TextUtils.isEmpty(client.getResponse())) {
        Logger.v("APIManager: fetchInAppCampaingn" + client.getResponse());
        return client.getResponse();
      }
    } catch (Exception e) {
      Logger.f("APIManager: fetchInAppCampaigns", e);
      InAppController.getInstance().trackAPIFailure(InAppController.SYNC_API_FAILURE);
    }
    return null;
  }

  /*
   * @param con Instance of the Application {@link Context}
   * @return returns the InAppMessage which needs to be shown for this auto
   * trigger event. If no in app is received then returns null
   */
  @Nullable static String logASmartEvent(Context con, String API, HashMap<String, String> paramsMap,
      JSONObject requestBody) {
    try {
      if (!ConfigurationCache.getInstance().getRemoteConfiguration().isAppEnabled() || !ConfigurationCache.getInstance()
          .getRemoteConfiguration().isInAppEnabled()) return null;
      MoERestClient client = new MoERestClient(API, con);
      client.addParam(paramsMap);
      if (requestBody != null) {
        client.addBody(requestBody);
      }
      client.execute(RequestMethod.POST);
      Logger.v("APIManager: Processing Smart event response");
      if (!isHttpStatusOk(client.getResponseCode())) {
        InAppController.getInstance().trackAPIFailure(InAppController.SMART_API_FAILURE);
        return null;
      }
      return client.getResponse();
    } catch (Exception e) {
      Logger.f("APIManager: logASmartEvent", e);
      InAppController.getInstance().trackAPIFailure(InAppController.SMART_API_FAILURE);
    }
    return null;
  }

  @Nullable static String fetchSingleInApp(Context context, String API,
      HashMap<String, String> requestParams) {
    try {
      if (!ConfigurationCache.getInstance().getRemoteConfiguration().isAppEnabled() || !ConfigurationCache
          .getInstance().getRemoteConfiguration().isInAppEnabled()) return null;
      MoERestClient client = new MoERestClient(API, context);
      client.addParam(requestParams);
      client.execute(RequestMethod.POST);
      if (!isHttpStatusOk(client.getResponseCode())) {
        InAppController.getInstance().trackAPIFailure(InAppController.SINGLE_API_FAILURE);
        return null;
      }
      return client.getResponse();
    } catch (Exception e) {
      Logger.f("APIManager: fetchInAppCampaigns", e);
      InAppController.getInstance().trackAPIFailure(InAppController.SINGLE_API_FAILURE);
    }
    return null;
  }

  static void uploadLogsToLogEntries(String api, JSONObject jsonObject) {
    try {
      URL url = new URL(api);
      HttpsURLConnection httpsURLConnection = (HttpsURLConnection) url.openConnection();
      httpsURLConnection.setDoOutput(true);
      httpsURLConnection.setRequestProperty("Accept-Charset", "UTF-8");
      httpsURLConnection.setRequestProperty("Content-type", "application/json");
      OutputStream output = httpsURLConnection.getOutputStream();
      output.write(jsonObject.toString().getBytes("UTF-8"));
      output.close();
      Logger.v(
          "API Manager : uploadLogsToLogEntries : response" + httpsURLConnection.getResponseCode());
    } catch (Exception e) {

    }
  }

  @Nullable
  static String fetchMessages(Context context, String API, HashMap<String, String> paramsMap) {
    try {
      if (!ConfigurationCache.getInstance().getRemoteConfiguration().isAppEnabled() || !ConfigurationCache
          .getInstance().getRemoteConfiguration().isPushAmpEnabled()) return null;
      MoERestClient client = new MoERestClient(API, context);
      client.addParam(paramsMap);
      client.execute(RequestMethod.POST);
      if (!isHttpStatusOk(client.getResponseCode())) return null;
      return client.getResponse();
    } catch (Exception e) {
      Logger.f("API Manager : fetchMessages exception", e);
    }
    return null;
  }

  @Nullable
  static APIResponse registerUnregisterDeviceForIntegrationVerification(Context context, String API,
      HashMap<String, String> paramsMap) {
    try {
      if (!ConfigurationCache.getInstance().getRemoteConfiguration().isAppEnabled())return null;
      MoERestClient client = new MoERestClient(API, context);
      if (paramsMap != null) {
        client.addParam(paramsMap);
      }
      client.execute(RequestMethod.POST);
      return new APIResponse(client.getResponse(), client.getResponseCode());
    } catch (Exception e) {
      Logger.f("APIManager : registerUnregisterDeviceForIntegrationVerification :", e);
    }
    return null;
  }

  @Nullable
  public static APIResponse deviceTriggerSyncRequest(Context context, String API, HashMap<String,
      String> paramsMap, JSONObject requestBody){
    try {
      if (!ConfigurationCache.getInstance().getRemoteConfiguration().isRealTimeTriggerEnabled()
          || !ConfigurationCache.getInstance().getRemoteConfiguration().isAppEnabled()) return null;
      MoERestClient client = new MoERestClient(API, context);
      if (paramsMap != null){
        client.addParam(paramsMap);
      }
      if (requestBody != null){
        client.addBody(requestBody);
      }
      client.execute(RequestMethod.POST);
      return new APIResponse(client.getResponse(), client.getResponseCode());
    } catch (Exception e) {
      Logger.f( "MoERestClient: deviceTriggerSyncRequest() : Exception ", e);
    }
    return null;
  }

  /**
   * Check if HTTP call was successful
   *
   * @param responseCode The HTTP response code
   * @return true if http status code is 200
   */
  static boolean isHttpStatusOk(int responseCode) {
    return 200 == responseCode;
  }

  /**
   * Checks to see if the API returns a valid response
   * @throws JSONException
   */
  static boolean isValidAPIResponse(String response) throws JSONException {
    if (TextUtils.isEmpty(response)) return false;
    JSONObject jsonResponse = new JSONObject(response);
    String result = jsonResponse.getString(MoEConstants.RESPONSE_ATTR_RESULT);
    return MoEConstants.RESULT_OK.equals(result);
  }

  @Nullable static Response reportAdd(String appId, String path, String requestId, JSONObject body)
      throws IOException {
    Uri.Builder uriBuilder = RestUtils.getBaseUriBuilder()
        .appendEncodedPath(path);

    RequestBuilder requestBuilder =
        RestUtils.getBaseRequestBuilder(uriBuilder.build(), RequestType.POST, appId)
            .addHeader(MoEConstants.REQUEST_HEADER_REQUEST_ID, requestId)
            .addBody(body);

    RestClient restClient = new RestClient(requestBuilder.build());
    return restClient.executeRequest();
  }

  @Nullable public static Response configApi(String appId, JSONObject requestBody) throws IOException {

    Uri.Builder uriBuilder = RestUtils.getBaseUriBuilder()
        .appendEncodedPath(MoEConstants.API_ENDPOINT_CONFIG_API)
        .appendEncodedPath(appId);

    Request request = RestUtils.getBaseRequestBuilder(uriBuilder.build(), RequestType.POST, appId)
        .addBody(requestBody)
        .build();

    RestClient restClient = new RestClient(request);
    return restClient.executeRequest();
  }
}
