/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.userattributes;

import android.content.Context;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.userattributes.TrackAttributeTask;
import org.json.JSONObject;

public class MoEAttributeManager {
    private static final String TAG = "MoEAttributeManager";
    private Context context;

    public MoEAttributeManager(Context context) {
        this.context = context;
    }

    public void setUserAttribute(JSONObject userJson) {
        if (!this.shouldTrackUserAttribute()) {
            return;
        }
        MoEDispatcher.getInstance(this.context).addTaskToQueueBeginning(new TrackAttributeTask(this.context, userJson, false));
    }

    public void setCustomUserAttribute(JSONObject userJson) {
        if (!this.shouldTrackUserAttribute()) {
            return;
        }
        MoEDispatcher.getInstance(this.context).addTaskToQueueBeginning(new TrackAttributeTask(this.context, userJson, true));
    }

    private boolean shouldTrackUserAttribute() {
        ConfigurationProvider provider = ConfigurationProvider.getInstance(this.context);
        if (!provider.isAppEnabled()) {
            Logger.e("MoEAttributeManager shouldTrackUserAttribute(): Account disabled will not track attribute");
            return false;
        }
        if (provider.isDataTrackingOptedOut()) {
            Logger.e("MoEAttributeManager shouldTrackUserAttribute(): Data tracking opt-ed out cannot track attribute");
            return false;
        }
        return true;
    }
}

