/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.remoteconfig;

import android.content.Context;
import com.moengage.core.ConfigurationCache;
import com.moengage.core.Logger;
import com.moengage.core.MoEDAO;
import com.moengage.core.MoEUtils;
import com.moengage.core.model.RemoteConfiguration;
import com.moengage.core.remoteconfig.RemoteConfigResponseParser;
import com.moengage.core.rest.Response;

class RemoteConfigResponseHandler {
    private static final String TAG = "RemoteConfigResponseHandler";
    private RemoteConfigResponseParser responseParser = new RemoteConfigResponseParser();

    RemoteConfigResponseHandler() {
    }

    boolean handleConfigApiResponse(Context context, Response response) {
        try {
            if (response == null) {
                Logger.e("RemoteConfigResponseHandler handleConfigApiResponse() : response object is null.");
                return false;
            }
            if (response.getResponseCode() != 200) {
                Logger.e("RemoteConfigResponseHandler handleConfigApiResponse() : Network Request failed, error: " + response.getErrorMessage());
                return false;
            }
            RemoteConfiguration remoteConfiguration = this.responseParser.parseConfigApiResponse(response);
            if (remoteConfiguration != null) {
                MoEDAO.getInstance(context).addOrUpdateRemoteConfiguration(remoteConfiguration, response.getResponseBody());
                ConfigurationCache.getInstance().setRemoteConfiguration(remoteConfiguration);
            }
            MoEDAO.getInstance(context).updateConfigApiSyncTime(MoEUtils.currentTime());
            return true;
        }
        catch (Exception e) {
            Logger.f("RemoteConfigResponseHandler handleConfigApiResponse() : ");
            return false;
        }
    }
}

