/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.remoteconfig;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import com.moengage.core.Logger;
import com.moengage.core.MoEEventManager;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.remoteconfig.RemoteConfigResponseHandler;
import com.moengage.core.rest.Request;
import com.moengage.core.rest.RequestBuilder;
import com.moengage.core.rest.RestClient;
import com.moengage.core.utils.RestUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.json.JSONObject;

public class ConfigApiNetworkTask
extends SDKTask {
    private static final String TAG = "ConfigApiNetworkTask";
    private Context mContext;

    public ConfigApiNetworkTask(Context context) {
        super(context);
        this.mContext = context;
    }

    @Override
    public TaskResult execute() {
        Logger.v("ConfigApiNetworkTask : executing Task");
        try {
            String appId = MoEUtils.getAppId(this.mContext);
            if (TextUtils.isEmpty((CharSequence)appId)) {
                Logger.e("ConfigApiNetworkTask execute(): Cannot make config api sync request without app id.");
                return this.mTaskResult;
            }
            Uri.Builder uriBuilder = RestUtils.getBaseUriBuilder().appendEncodedPath("v3/sdkconfig/android/").appendEncodedPath(appId);
            JSONObject requestBody = new JSONObject();
            requestBody.put("query_params", (Object)RestUtils.getDefaultParams(this.mContext).build());
            Request request = RestUtils.getBaseRequestBuilder(uriBuilder.build(), RequestBuilder.RequestType.POST, appId).addBody(requestBody).build();
            RestClient restClient = new RestClient(request);
            RemoteConfigResponseHandler handler = new RemoteConfigResponseHandler();
            boolean status = handler.handleConfigApiResponse(this.mContext, restClient.executeRequest());
            MoEEventManager.getInstance(this.mContext).updateEventListFromRemote();
            this.mTaskResult.setIsSuccess(status);
        }
        catch (Exception e) {
            Logger.f("ConfigApiNetworkTask : execute", e);
        }
        Logger.v("ConfigApiNetworkTask : execution completed");
        return this.mTaskResult;
    }

    @Override
    public String getTaskTag() {
        return "SYNC_CONFIG";
    }

    @Override
    public boolean isSynchronous() {
        return true;
    }

    public static String readFromResources(Context context, int resourceId) {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(context.getResources().openRawResource(resourceId)));
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                line = br.readLine();
            }
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

