package com.moengage.core.reports;

import android.content.Context;
import android.support.annotation.Nullable;
import com.moe.pushlibrary.models.BatchData;
import com.moengage.core.Logger;
import com.moengage.core.MoEConstants;
import com.moengage.core.MoEDAO;
import com.moengage.core.MoEUtils;
import com.moengage.core.model.DevicePreferences;
import com.moengage.core.model.ReportBatchMeta;
import com.moengage.core.model.SDKIdentifiers;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * @author Umang Chamaria
 * Date: 2019-06-06
 */
public class ReportsBatchHelper {

  private static final String TAG = "ReportsBatchHelper";

  public BatchData updateBatchIfRequired(Context context, BatchData batch) {
    try {
      JSONObject batchJson = batch.batchData;
      if (batchJson.has(MoEConstants.REQUEST_HEADER_REQUEST_ID)) {
        Logger.v(TAG + " updateBatchIfRequired() : Batch already updated. No update required.");
        return batch;
      }
      Logger.v(TAG + " updateBatchIfRequired() : Batch does not have request id and time will add"
          + " it now.");
      batch.batchData = updateBatch(batchJson,
          MoEDAO.getInstance(context).getSDKIdentifiers());
      ;
      if (batch._id != -1) {
        MoEDAO.getInstance(context).updateBatch(batch);
      }
    } catch (Exception e) {
      Logger.f(TAG + " updateBatchIfRequired() : Exception ", e);
    }
    return batch;
  }

  JSONObject updateBatch(JSONObject batchJson,
      SDKIdentifiers identifiers) throws JSONException {
    ReportBatchMeta batchMeta = getBatchMeta(batchJson);

    JSONObject metaJson = new JSONObject();
    metaJson.put(MoEConstants.ATTR_BATCH_ID, batchMeta.getBatchId());
    metaJson.put(MoEConstants.REQUEST_ATTR_REQUEST_TIME, batchMeta.getRequestTime());
    JSONObject preferencesJson = devicePreferencesJson(batchMeta.getPreferences());
    if (preferencesJson != null) {
      metaJson.put(MoEConstants.REQUEST_ATTR_DEVICE_PREFERENCE, preferencesJson);
    }
    batchJson.put(MoEConstants.ATTR_SDK_META, metaJson);
    String requestId =
        MoEUtils.getSha1ForString(
            batchMeta.getBatchId() + batchMeta.getRequestTime() + identifiers.getSdkUniqueId());
    batchJson.put(MoEConstants.REQUEST_HEADER_REQUEST_ID, requestId);
    return batchJson;
  }

  ReportBatchMeta getBatchMeta(JSONObject batchJson) {
    ReportBatchMeta batchMeta = savedBatchMeta(batchJson);
    if (batchMeta == null) {
      batchMeta = new ReportBatchMeta(null,
          MoEUtils.getBatchId(), MoEUtils.getCurrentISOTime());
    } else {
      if (MoEUtils.isEmptyString(batchMeta.getBatchId())) {
        batchMeta.setBatchId(MoEUtils.getBatchId());
      }
      if (MoEUtils.isEmptyString(batchMeta.getRequestTime())) {
        batchMeta.setRequestTime(MoEUtils.getCurrentISOTime());
      }
    }
    return batchMeta;
  }

  @Nullable ReportBatchMeta savedBatchMeta(JSONObject batchJson) {
    try {
      if (!batchJson.has(MoEConstants.ATTR_SDK_META)) return null;
      JSONObject metaJson = batchJson.getJSONObject(MoEConstants.ATTR_SDK_META);
      ReportBatchMeta batchMeta = new ReportBatchMeta();
      if (metaJson.has(MoEConstants.ATTR_BATCH_ID)) {
        batchMeta.setBatchId(metaJson.getString(MoEConstants.ATTR_BATCH_ID));
      }
      if (metaJson.has(MoEConstants.REQUEST_ATTR_REQUEST_TIME)) {
        batchMeta.setRequestTime(metaJson.getString(MoEConstants.REQUEST_ATTR_REQUEST_TIME));
      }
      if (metaJson.has(MoEConstants.REQUEST_ATTR_DEVICE_PREFERENCE)) {
        JSONObject devicePreferences =
            metaJson.getJSONObject(MoEConstants.REQUEST_ATTR_DEVICE_PREFERENCE);
        DevicePreferences preferences = new DevicePreferences();
        if (devicePreferences.has(MoEConstants.REQUEST_ATTR_DATA_TRACKING_PREFERENCE)) {
          preferences.setDataTrackingOptedOut(true);
        }
        if (devicePreferences.has(MoEConstants.REQUEST_ATTR_IN_APP_PREFERENCE)) {
          preferences.setInAppOptedOut(true);
        }
        if (devicePreferences.has(MoEConstants.REQUEST_ATTR_PUSH_PREFERENCE)) {
          preferences.setPushOptedOut(true);
        }
        batchMeta.setPreferences(preferences);
      }
      return batchMeta;
    } catch (Exception e) {
      Logger.e(TAG + " batchMetaFromJson() : ");
    }
    return null;
  }

  @Nullable JSONObject devicePreferencesJson(DevicePreferences preferences) {
    JSONObject preferencesJson = new JSONObject();
    try {
      if (preferences == null) return null;
      if (preferences.isDataTrackingOptedOut()) {
        preferencesJson.put(MoEConstants.REQUEST_ATTR_DATA_TRACKING_PREFERENCE,
            !preferences.isDataTrackingOptedOut());
      }
      if (preferences.isPushOptedOut()) {
        preferencesJson.put(MoEConstants.REQUEST_ATTR_PUSH_PREFERENCE,
            !preferences.isPushOptedOut());
      }
      if (preferences.isInAppOptedOut()) {
        preferencesJson.put(MoEConstants.REQUEST_ATTR_IN_APP_PREFERENCE,
            !preferences.isInAppOptedOut());
      }
    } catch (Exception e) {
      Logger.e(TAG + " devicePreferencesJson() : Exception: ", e);
    }
    return preferencesJson.length() > 0 ? preferencesJson : null;
  }

  @Nullable JSONObject identifierJson(SDKIdentifiers identifiers) {
    JSONObject identifiersJson = new JSONObject();
    try {
      if (identifiers.getUserAttributeUniqueId() != null) {
        identifiersJson.put(MoEConstants.ATTR_MOE_USER_ID, identifiers.getUserAttributeUniqueId());
      }
      if (identifiers.getSegmentAnonymousId() != null) {
        identifiersJson.put(MoEConstants.ATTR_SEGMENT_ID, identifiers.getSegmentAnonymousId());
      }
    } catch (Exception e) {
      Logger.e(TAG + " getIdentifiers() : Exception: ", e);
    }
    return identifiersJson.length() > 0 ? identifiersJson : null;
  }
}
