package com.moengage.core.remoteconfig;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import com.moengage.core.Logger;
import com.moengage.core.MoEConstants;
import com.moengage.core.MoEEventManager;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.rest.Request;
import com.moengage.core.rest.RequestBuilder.RequestType;
import com.moengage.core.rest.RestClient;
import com.moengage.core.utils.RestUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.json.JSONObject;

/**
 * @author Umang Chamaria
 */
public class ConfigApiNetworkTask extends SDKTask{
  private static final String TAG = "ConfigApiNetworkTask";
  private Context mContext;

  public ConfigApiNetworkTask(Context context){
    super(context);
    mContext = context;
  }

  @Override public TaskResult execute() {
    Logger.v("ConfigApiNetworkTask : executing Task");
    try {
      String appId = MoEUtils.getAppId(mContext);
      if (TextUtils.isEmpty(appId)){
        Logger.e(TAG + " execute(): Cannot make config api sync request without app id.");
        return mTaskResult;
      }
      Uri.Builder uriBuilder = RestUtils.getBaseUriBuilder()
          .appendEncodedPath(MoEConstants.API_ENDPOINT_CONFIG_API)
          .appendEncodedPath(appId);

      JSONObject requestBody = new JSONObject();
      requestBody.put(MoEConstants.REQUEST_ATTR_QUERY_PARAMS,
          RestUtils.getDefaultParams(mContext).build());
      Request request = RestUtils.getBaseRequestBuilder(uriBuilder.build(), RequestType.POST, appId)
          .addBody(requestBody)
          .build();
      RestClient restClient = new RestClient(request);
      RemoteConfigResponseHandler handler = new RemoteConfigResponseHandler();
      boolean status = handler.handleConfigApiResponse(mContext, restClient.executeRequest());

      MoEEventManager.getInstance(mContext).updateEventListFromRemote();
      mTaskResult.setIsSuccess(status);
    } catch (Exception e) {
      Logger.f("ConfigApiNetworkTask : execute", e);
    }
    Logger.v("ConfigApiNetworkTask : execution completed");
    return mTaskResult;
  }

  @Override public String getTaskTag() {
    return TAG_SYNC_CONFIG_API;
  }

  @Override public boolean isSynchronous() {
    return true;
  }

  public static String readFromResources(Context context, int resourceId) {
    try {
      BufferedReader br =
          new BufferedReader(
              new InputStreamReader(context.getResources().openRawResource(resourceId)));
      StringBuilder sb = new StringBuilder();
      String line = br.readLine();
      while (line != null) {
        sb.append(line);
        line = br.readLine();
      }
      return sb.toString();
    } catch (Exception e) {
      e.printStackTrace();
    }
    return null;
  }
}
