package com.moengage.core.model;

public class DevicePreferences {
  private boolean isDataTrackingOptedOut;
  private boolean isPushOptedOut;
  private boolean isInAppOptedOut;

  public DevicePreferences(){

  }

  public DevicePreferences(boolean isDataTrackingOptedOut, boolean isPushOptedOut,
      boolean isInAppOptedOut) {
    this.isDataTrackingOptedOut = isDataTrackingOptedOut;
    this.isPushOptedOut = isPushOptedOut;
    this.isInAppOptedOut = isInAppOptedOut;
  }

  public boolean isDataTrackingOptedOut() {
    return isDataTrackingOptedOut;
  }

  public boolean isPushOptedOut() {
    return isPushOptedOut;
  }

  public boolean isInAppOptedOut() {
    return isInAppOptedOut;
  }

  public void setDataTrackingOptedOut(boolean dataTrackingOptedOut) {
    isDataTrackingOptedOut = dataTrackingOptedOut;
  }

  public void setPushOptedOut(boolean pushOptedOut) {
    isPushOptedOut = pushOptedOut;
  }

  public void setInAppOptedOut(boolean inAppOptedOut) {
    isInAppOptedOut = inAppOptedOut;
  }

  @Override public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    DevicePreferences that = (DevicePreferences) o;

    if (isDataTrackingOptedOut != that.isDataTrackingOptedOut) return false;
    if (isPushOptedOut != that.isPushOptedOut) return false;
    return isInAppOptedOut == that.isInAppOptedOut;
  }

}