package com.moengage.core.executor;

import android.content.Context;

/**
 * @author Umang Chamaria on 11/17/15.
 */
public abstract class SDKTask implements ITask {

  protected static final String TAG_CHECK_IN_APPS = "CHECK_IN_APPS";
  public static final String TAG_ACTIVITY_START = "START_ACTIVITY";
  protected static final String TAG_SHOW_IN_APP_ON_CONFIG_CHANGE = "SHOW_IN_APP_ON_CONFIG_CHANGE";
  protected static final String TAG_NOTIFICATION_CLICKED = "NOTIFICATION_CLICKED";
  protected static final String TAG_TRACK_EVENT = "TRACK_EVENT";
  protected static final String TAG_GEO_TASK = "GEO_TASK";
  protected static final String TAG_LOG_IN_APP_CLICKED = "IN_APP_CLICKED";
  public static final String TAG_DEVICE_ADD = "DEVICE_ADD";
  protected static final String TAG_SHOW_LINKED_IN_APP = "SHOW_LINKED_IN_APP";
  public static final String TAG_SEND_INTERACTION_DATA = "SEND_INTERACTION_DATA";
  protected static final String TAG_ACTIVITY_STOP = "ACTIVITY_STOP";
  protected static final String TAG_CHECK_AND_SHOW_NUDGE = "CHECK_AND_SHOW_NUDGE";
  public static final String TAG_INAPP_NETWORK_TASK = "INAPP_NETWORK_TASK";
  protected static final String TAG_SHOW_SELF_HANDLED_INAPP = "SHOW_SELF_HANDLED_INAPP";
  protected static final String TAG_SEND_LOG = "SEND_LOG";
  public static final String TAG_SYNC_CONFIG_API = "SYNC_CONFIG";
  protected static final String TAG_FETCH_MESSAGES = "FETCH_MESSAGES";
  public static final String TAG_INTEGRATION_VERIFICATION_NETWORK_TASK =
      "INTEGRATION_VERIFICATION_NETWORK_TASK";
  protected static final String TAG_SET_ALIAS = "SET_ALIAS";
  protected static final String TAG_SET_DEVICE_ATTRIBUTES = "SET_DEVICE_ATTRIBUTES";
  protected static final String TAG_MOE_WORKER_TASK = "MOE_WORKER_TASK";
  protected static final String TAG_MOE_PUSH_WORKER_TASK = "MOE_PUSH_WORKER_TASK";
  protected static final String TAG_CREATE_DATA_BATCH = "CREATE_DATA_BATCH";
  protected static final String TAG_CHECK_AND_SHOW_DT = "CHECK_AND_SHOW_DT";
  protected static final String TAG_DT_NETWORK_CALL_TASK = "DT_NETWORK_CALL_TASK";
  protected static final String TAG_DATA_TRACKING_OPT_OUT_TASK = "DATA_TRACKING_OPT_OUT_TASK";
  protected static final String TAG_UPDATE_OPT_OUT_TO_SERVER_TASK = "UPDATE_OPT_OUT_TO_SERVER_TASK";
  public static final String TAG_TRACK_ATTRIBUTE = "TRACK_ATTRIBUTE";
  protected static final String TAG_TRACK_EVENT_SEGMENT = "TRACK_EVENT_SEGMENT";
  protected static final String TAG_TRACK_USER_ATTRIBUTE_SEGMENT = "TRACK_USER_ATTRIBUTE_SEGMENT";
  protected static final String TAG_LOAD_CONFIGURATION_FROM_DISK = "LOAD_CONFIGURATION_FROM_DISK";



  protected Context mContext;
  protected TaskResult mTaskResult;

  public SDKTask(Context context) {
    mContext = context;
    mTaskResult = new TaskResult();
    mTaskResult.setIsSuccess(false);
  }

  @Override public void onPostExecute(TaskResult result) {

  }

  public TaskResult createTaskResult(Object payload, boolean taskState){
    mTaskResult.setPayload(payload);
    mTaskResult.setIsSuccess(taskState);
    return mTaskResult;
  }
}