package com.moengage.core;

import android.content.Context;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.model.RemoteConfiguration;
import org.json.JSONObject;

public class LoadConfigurationFromDiskTask extends SDKTask {
  private static final String TAG = "LoadConfigurationFromDiskTask";

  LoadConfigurationFromDiskTask(Context context) {
    super(context);
  }

  @Override public TaskResult execute() {
    loadRemoteConfigFromDisk();
    return null;
  }

  private void loadRemoteConfigFromDisk() {
    try {
      String configurationString =
          ConfigurationProvider.getInstance(mContext).getRemoteConfiguration();
      RemoteConfiguration configuration = new RemoteConfiguration();

      if (configurationString != null){
        RemoteConfiguration storedConfig =
            RemoteConfiguration.fromJson(new JSONObject(configurationString));
        if (storedConfig != null){
          configuration = storedConfig;
        }
      }

      ConfigurationCache.getInstance().setRemoteConfiguration(configuration);
    } catch (Exception e) {
      Logger.e( TAG + " loadRemoteConfigFromDisk() : Exception ", e);
    }
  }

  @Override public String getTaskTag() {
    return TAG_LOAD_CONFIGURATION_FROM_DISK;
  }

  @Override public boolean isSynchronous() {
    return true;
  }

}