/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import com.moe.pushlibrary.exceptions.SDKNotInitializedException;
import com.moengage.core.AdvertisingIdClient;
import com.moengage.core.ConfigurationCache;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

final class MoERestClient {
    private static String ANDROID_ID = null;
    private static boolean androidIDRetrieved = false;
    private HashMap<String, String> params;
    private HashMap<String, String> headers;
    private JSONObject jsonBody = null;
    private String url;
    private JSONObject queryParams;
    private int responseCode;
    private String response;
    private String errorResponse;
    private String appId;
    private static final String SCHEME_HTTPS = "https://";

    public String getResponse() {
        return this.response;
    }

    int getResponseCode() {
        return this.responseCode;
    }

    MoERestClient(String url, Context con) throws SDKNotInitializedException {
        this.url = url;
        this.params = new HashMap();
        if (!androidIDRetrieved) {
            androidIDRetrieved = true;
            ANDROID_ID = MoEUtils.getAndroidID(con);
        }
        this.appId = MoEUtils.getAppId(con);
        if (TextUtils.isEmpty((CharSequence)this.appId)) {
            throw new SDKNotInitializedException("App ID has not been set");
        }
        this.queryParams = new JSONObject();
        this.initializeRestClient(con);
        this.headers = new HashMap();
        this.headers.put("MOE-APPKEY", this.appId);
    }

    private void initializeRestClient(Context con) throws SDKNotInitializedException {
        try {
            ConfigurationProvider provider = ConfigurationProvider.getInstance(con);
            String registrationId = provider.getGCMToken();
            String newUniqueID = provider.getCurrentUserId();
            String appVersion = Integer.toString(provider.getAppVersion());
            long millis = MoEUtils.currentTime();
            if (!TextUtils.isEmpty((CharSequence)registrationId) && !provider.isPushNotificationOptedOut()) {
                this.queryParams.put("push_id", (Object)registrationId);
            }
            if (!TextUtils.isEmpty((CharSequence)newUniqueID)) {
                this.queryParams.put("unique_id", (Object)newUniqueID);
            }
            if (!TextUtils.isEmpty((CharSequence)appVersion)) {
                this.queryParams.put("app_ver", (Object)appVersion);
            }
            this.queryParams.put("app_id", (Object)this.appId);
            this.queryParams.put("os", (Object)"ANDROID");
            this.queryParams.put("sdk_ver", (Object)Integer.toString(9404));
            this.queryParams.put("device_tz_offset", (Object)String.valueOf(TimeZone.getDefault().getOffset(millis)));
            this.queryParams.put("device_ts", (Object)String.valueOf(millis));
            this.queryParams.put("device_tz", (Object)TimeZone.getDefault().getID());
            this.queryParams.put("moe_push_ser", (Object)ConfigurationCache.getInstance().getPushService());
            String miPushToken = provider.getMiPushToken();
            if (!TextUtils.isEmpty((CharSequence)miPushToken) && !provider.isPushNotificationOptedOut()) {
                this.queryParams.put("mi_push_id", (Object)miPushToken);
            }
            this.addPlatformIfRequired(provider);
            this.addSegmentParamIfRequired(con);
            if (!provider.isDataTrackingOptedOut()) {
                if (!TextUtils.isEmpty((CharSequence)ANDROID_ID)) {
                    this.queryParams.put("android_id", (Object)ANDROID_ID);
                }
                if (!provider.isAdIdCollectionProhibitted()) {
                    AdvertisingIdClient.AdInfo adInfo;
                    String gaid = provider.getStoredGAID();
                    if (TextUtils.isEmpty((CharSequence)gaid) && (adInfo = MoEUtils.getAdvertisementInfo(con)) != null) {
                        gaid = adInfo.getId();
                        provider.storeGAID(gaid);
                    }
                    if (!TextUtils.isEmpty((CharSequence)gaid)) {
                        this.queryParams.put("moe_gaid", (Object)gaid);
                    }
                }
                this.queryParams.put("os_ver", (Object)String.valueOf(Build.VERSION.SDK_INT));
                this.queryParams.put("model", (Object)Build.MODEL);
                this.queryParams.put("app_version_name", (Object)provider.getAppVersionName());
                String nwType = MoEUtils.getNetworkType(con);
                if (!TextUtils.isEmpty((CharSequence)nwType)) {
                    this.queryParams.put("networkType", (Object)nwType);
                }
            }
        }
        catch (Exception e) {
            Logger.e("MoERestClient: initializeRestClient() : ", e);
        }
    }

    private void addParam(String name, String Value) {
        this.params.put(name, Value);
    }

    void addParam(HashMap<String, String> paramsMap) {
        for (Map.Entry<String, String> entry : paramsMap.entrySet()) {
            this.params.put(entry.getKey(), entry.getValue());
        }
    }

    void addBody(JSONObject requestBody) {
        this.jsonBody = requestBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String convertStreamToString(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            Logger.f("MoERestClient:executeRequest: IOException", e);
        }
        catch (Exception e) {
            Logger.f("MoERestClient:executeRequest: Exception", e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                Logger.f("MoERestClient:executeRequest: IOException", e);
            }
            catch (Exception e) {
                Logger.f("MoERestClient:executeRequest: Exception", e);
            }
        }
        return sb.toString();
    }

    public void execute(RequestMethod method) throws IOException {
        URL finalURL = new URL(this.url);
        Logger.d("MoERestClient: executing API: " + finalURL.toString());
        HttpURLConnection urlConnection = null;
        if (this.url.startsWith(SCHEME_HTTPS)) {
            urlConnection = (HttpsURLConnection)urlConnection;
            urlConnection = (HttpsURLConnection)finalURL.openConnection();
        } else {
            urlConnection = (HttpURLConnection)finalURL.openConnection();
        }
        if (method == RequestMethod.POST) {
            this.addBody(urlConnection);
        } else {
            urlConnection.setRequestMethod("GET");
            this.addHeaders(urlConnection);
        }
        this.responseCode = urlConnection.getResponseCode();
        Logger.d("MoERestClient: ResponseCode: " + this.responseCode);
        if (200 != this.responseCode) {
            this.errorResponse = this.convertStreamToString(urlConnection.getErrorStream());
            Logger.f("MoERestClient: Response: API Failed: " + this.url + " response code :" + this.responseCode + "reason : " + this.errorResponse);
            if (!TextUtils.isEmpty((CharSequence)this.errorResponse)) {
                Logger.f("MoERestClient: with reason: " + this.errorResponse);
            }
            return;
        }
        InputStream in = urlConnection.getInputStream();
        this.response = this.convertStreamToString(in);
        urlConnection.disconnect();
        if (!TextUtils.isEmpty((CharSequence)this.response)) {
            Logger.d("MoERestClient: Response: " + this.response);
        }
    }

    private void addBody(HttpURLConnection connection) throws IOException {
        connection.setDoOutput(true);
        connection.setRequestProperty("Accept-Charset", "UTF-8");
        connection.setRequestProperty("Content-type", "application/json");
        this.addHeaders(connection);
        this.addParamsToBody();
        if (this.jsonBody != null) {
            Logger.d("MoERestClient: addBody: string: " + this.jsonBody);
        }
        OutputStream output = connection.getOutputStream();
        if (this.jsonBody != null) {
            output.write(this.jsonBody.toString().getBytes("UTF-8"));
        }
        output.close();
    }

    private void addPlatformIfRequired(ConfigurationProvider provider) {
        String platform = provider.getUnityVersion();
        if (!TextUtils.isEmpty((CharSequence)platform)) {
            this.addParam("unity_ver", platform);
        }
    }

    private void addSegmentParamIfRequired(Context context) {
        if (ConfigurationProvider.getInstance(context).isSegmentEnabled()) {
            this.addParam("integration_type", "segment");
        }
    }

    void addHeader(String headerName, String headerValue) {
        this.headers.put(headerName, headerValue);
    }

    void addHeaders(HashMap<String, String> headersMap) {
        for (Map.Entry<String, String> entry : headersMap.entrySet()) {
            this.headers.put(entry.getKey(), entry.getValue());
        }
    }

    private void addHeaders(HttpURLConnection urlConnection) {
        Set<Map.Entry<String, String>> headerMap = this.headers.entrySet();
        for (Map.Entry<String, String> header : headerMap) {
            Logger.v("MoERestClient: addHeaders(): " + header.getKey() + " : " + header.getValue());
            urlConnection.addRequestProperty(header.getKey(), header.getValue());
        }
    }

    private void addParamsToBody() {
        try {
            Set<Map.Entry<String, String>> mapParams = this.params.entrySet();
            for (Map.Entry<String, String> param : mapParams) {
                try {
                    this.queryParams.put(param.getKey(), (Object)param.getValue());
                }
                catch (Exception e) {
                    Logger.e("MoERestClient: addParamsToBody() ", e);
                }
            }
            if (this.jsonBody == null) {
                this.jsonBody = new JSONObject();
            }
            this.jsonBody.put("query_params", (Object)this.queryParams);
        }
        catch (JSONException e) {
            Logger.e("MoERestClient: addParamsToBody() : ", e);
        }
    }

    public static enum RequestMethod {
        GET,
        POST;

    }
}

