/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import android.os.Bundle;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.DeviceAddTask;
import com.moengage.core.Logger;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.utils.JsonBuilder;
import org.json.JSONObject;

public class DeviceAddManager {
    private static final String TAG = "DeviceAddManager";
    public static final String CONSTANT_FCM_TOKEN_PRESENT = "is_fcm_token_present";
    public static final String CONSTANT_MI_TOKEN_PRESENT = "is_gcm_token_present";
    private boolean isDeviceAddInProgress;
    private boolean isFcmRegistrationPending;
    private boolean isMiRegistrationPending;
    private boolean isGdprRequestPending;

    public void registerGdprOptOut(Context context) {
        if (this.isDeviceAddInProgress) {
            Logger.v("DeviceAddManager registerGdprOptOut() : Device Add is in progress, will send gdpr opt-out after current request completes.");
            this.isGdprRequestPending = true;
        } else {
            Logger.v("DeviceAddManager registerGdprOptOut() : Initiating request to send GDPR opt out.");
            this.initiateDeviceAdd(context);
        }
    }

    public void registerFcmToken(Context context) {
        if (this.isDeviceAddInProgress) {
            Logger.v("DeviceAddManager registerFcmToken() : Device add in progress will send FCM token to server after current request completes.");
            this.isFcmRegistrationPending = true;
        } else {
            Logger.v("DeviceAddManager registerFcmToken() : Initiating request for sending FCM token to server.");
            this.initiateDeviceAdd(context);
        }
    }

    public void registerMiToken(Context context) {
        ConfigurationProvider.getInstance(context).setMiTokenServerSentState(false);
        if (this.isDeviceAddInProgress) {
            Logger.v("DeviceAddManager registerMiToken() : Device add in progress will send Mi Push token to server after current request completes.");
            this.isMiRegistrationPending = true;
        } else {
            Logger.v("DeviceAddManager registerMiToken() : Initiating request for sending Mi Push token to server");
            this.initiateDeviceAdd(context);
        }
    }

    void retryDeviceRegistrationIfRequired(Context context) {
        ConfigurationProvider provider = ConfigurationProvider.getInstance(context);
        if (!provider.isDeviceRegistered()) {
            Logger.v("DeviceAddManager retryDeviceRegistrationIfRequired() : Device not registered yet. Will try to register device.");
            this.initiateDeviceAdd(context);
        }
    }

    private void initiateDeviceAdd(Context context) {
        if (!this.isDeviceAddInProgress) {
            this.isDeviceAddInProgress = true;
            ConfigurationProvider.getInstance(context).setDeviceRegistrationState(false);
            MoEDispatcher.getInstance(context).addTaskToQueue(new DeviceAddTask(context, this.getPreferencesJson(context)));
        } else {
            Logger.v("DeviceAddManager initiateDeviceAdd() : Device Add is already in progress cannot schedule another one");
        }
    }

    void processTaskResult(Context context, TaskResult taskResult) {
        try {
            this.isDeviceAddInProgress = false;
            Logger.v("DeviceAddManager processTaskResult() : Device Add completed, processing response.");
            if (taskResult == null) {
                return;
            }
            ConfigurationProvider provider = ConfigurationProvider.getInstance(context);
            provider.setDeviceRegistrationState(taskResult.isSuccess());
            if (!taskResult.isSuccess()) {
                Logger.v("DeviceAddManager processTaskResult() : Device add failed recently");
                return;
            }
            Bundle pushParams = (Bundle)taskResult.getPayload();
            if (pushParams == null) {
                return;
            }
            boolean hasSentMiToken = pushParams.getBoolean(CONSTANT_MI_TOKEN_PRESENT, false);
            boolean hasSentFcmToken = pushParams.getBoolean(CONSTANT_FCM_TOKEN_PRESENT, false);
            if (hasSentFcmToken) {
                this.isFcmRegistrationPending = false;
            }
            if (hasSentMiToken) {
                this.isMiRegistrationPending = false;
            }
            provider.setFcmTokenServerSendState(hasSentFcmToken);
            provider.setMiTokenServerSentState(hasSentMiToken);
            if (this.isMiRegistrationPending) {
                this.isMiRegistrationPending = false;
                this.registerMiToken(context);
            }
            if (this.isFcmRegistrationPending) {
                this.isFcmRegistrationPending = false;
                this.registerFcmToken(context);
            }
            if (this.isGdprRequestPending) {
                this.isGdprRequestPending = false;
                this.registerGdprOptOut(context);
            }
        }
        catch (Exception e) {
            Logger.e("DeviceAddManager processTaskResult() : Exception ", e);
        }
    }

    private JSONObject getPreferencesJson(Context context) {
        JsonBuilder preferences = new JsonBuilder();
        ConfigurationProvider provider = ConfigurationProvider.getInstance(context);
        try {
            preferences.putBoolean("push_p", !provider.isPushNotificationOptedOut());
            preferences.putBoolean("in_app_p", !provider.isInAppOptedOut());
            preferences.putBoolean("e_t_p", !provider.isDataTrackingOptedOut());
        }
        catch (Exception e) {
            Logger.e("DeviceAddManager getPreferencesJson() : Exception: ", e);
        }
        return preferences.build();
    }
}

