package com.moengage.core.remoteconfig;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import com.moengage.core.Logger;
import com.moengage.core.MoEConstants;
import com.moengage.core.MoEEventManager;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.rest.Request;
import com.moengage.core.rest.RequestBuilder.RequestType;
import com.moengage.core.rest.Response;
import com.moengage.core.rest.RestClient;
import com.moengage.core.utils.RestUtils;
import org.json.JSONObject;

/**
 * @author Umang Chamaria
 */
public class ConfigApiNetworkTask extends SDKTask{
  private static final String TAG = "ConfigApiNetworkTask";
  private Context mContext;

  public ConfigApiNetworkTask(Context context){
    super(context);
    mContext = context;
  }

  @Override public TaskResult execute() {
    Logger.v("ConfigApiNetworkTask : executing Task");
    try {
      String appId = MoEUtils.getAppId(mContext);
      if (TextUtils.isEmpty(appId)){
        Logger.e(TAG + " execute(): Cannot make config api sync request without app id.");
        return null;
      }
      Uri.Builder uriBuilder = RestUtils.getBaseUriBuilder(mContext)
          .appendEncodedPath(MoEConstants.API_ENDPOINT_CONFIG_API)
          .appendEncodedPath(appId);
      JSONObject requestBody = new JSONObject();
      requestBody.put(MoEConstants.REQUEST_ATTR_QUERY_PARAMS,
          RestUtils.getDefaultParams(mContext).build());
      Request request = RestUtils.getBaseRequestBuilder(uriBuilder.build(), RequestType.POST, appId)
          .addBody(requestBody)
          .build();
      RestClient restClient = new RestClient(request);
      Response response = restClient.executeRequest();
      RemoteConfigResponseHandler handler = new RemoteConfigResponseHandler();
      handler.handleConfigApiResponse(mContext, response);

      MoEEventManager.getInstance(mContext).updateEventListFromRemote();
    } catch (Exception e) {
      Logger.f("ConfigApiNetworkTask : execute", e);
    }
    Logger.v("ConfigApiNetworkTask : execution completed");
    return null;
  }

  @Override public String getTaskTag() {
    return TAG_SYNC_CONFIG_API;
  }

  @Override public boolean isSynchronous() {
    return true;
  }
}
