package com.moengage.core;

import android.content.Context;
import com.moe.pushlibrary.models.Event;
import com.moe.pushlibrary.utils.MoEHelperConstants;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;

/**
 * (non-JavaDoc)
 * Tracks an event and send the data to the server in case the event has USER_ATTRIBUTE_UNIQUE_ID
 * set.
 * Service Constant - MSG_TRACK_EVENT
 * @author Umang Chamaria
 */
class TrackEventTask extends SDKTask {
  private static final String TAG = "TrackEventTask";
  Event event;
  TrackEventTask(Context context, Event event) {
    super(context);
    this.event = event;
  }

  @Override public TaskResult execute() {
    Logger.v("TrackEventTask : executing task");
    MoEDAO.getInstance(mContext).addEvent(event, mContext);
    MoEEventManager.getInstance(mContext).incrementEventCounter();
    Logger.v(TAG + " execute() : Cached event count: " + MoEEventManager.getInstance
        (mContext).getEventCounter());
    if(event.details.contains(MoEHelperConstants.USER_ATTRIBUTE_UNIQUE_ID)){
      Logger.d("Unique Id set, So will try to send data");
      MoEDispatcher.getInstance(mContext).addTaskToQueue(new CreatingDataBatchTask(mContext));
    }else if (MoEEventManager.getInstance(mContext).getEventCounter() == ConfigurationProvider
        .getInstance(mContext).getEventBatchCount()){
      MoEDispatcher.getInstance(mContext).addTaskToQueue(new CreatingDataBatchTask(mContext));
    }
    Logger.v("TrackEventTask : completed execution");
    return null;
  }

  @Override public String getTaskTag() {
    return TAG_TRACK_EVENT;
  }

  @Override public boolean isSynchronous() {
    return false;
  }
}
