package com.moengage.core;

import android.content.Context;
import com.moe.pushlibrary.providers.MoEDataContract;
import com.moe.pushlibrary.providers.MoEDataContract.UserAttributeEntity;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.location.GeoManager;

/**
 * Called when the end user opts-out of data tracking.
 * Flushes out user attributes, events
 *
 * @author Umang Chamaria
 */
class DataTrackingOptOutTask extends SDKTask{
  private Context context;

  DataTrackingOptOutTask(Context context) {
    super(context);
    this.context = context;
  }

  @Override public TaskResult execute() {
    MoEDAO.getInstance(context).deleteAllEvents();
    MoEDAO.getInstance(context).deleteAllBatches();
    mContext.getContentResolver()
        .delete(MoEDataContract.UserAttributeEntity.getContentUri(mContext), UserAttributeEntity
                .ATTRIBUTE_NAME + " != ?", new String[]{"APP_UUID"});
    GeoManager.getInstance().removeGeoFences(mContext);
    return null;
  }

  @Override public String getTaskTag() {
    return TAG_DATA_TRACKING_OPT_OUT_TASK;
  }

  @Override public boolean isSynchronous() {
    return true;
  }
}
