/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.reports;

import android.content.Context;
import android.support.annotation.Nullable;
import com.moe.pushlibrary.models.BatchData;
import com.moengage.core.Logger;
import com.moengage.core.MoEDAO;
import com.moengage.core.MoEUtils;
import com.moengage.core.model.DevicePreferences;
import com.moengage.core.model.ReportBatchMeta;
import com.moengage.core.model.SDKIdentifiers;
import org.json.JSONException;
import org.json.JSONObject;

public class ReportsBatchHelper {
    private static final String TAG = "ReportsBatchHelper";

    public BatchData updateBatchIfRequired(Context context, BatchData batch) {
        try {
            JSONObject batchJson = batch.batchData;
            if (batchJson.has("MOE-REQUEST-ID")) {
                Logger.v("ReportsBatchHelper updateBatchIfRequired() : Batch already updated. No update required.");
                return batch;
            }
            Logger.v("ReportsBatchHelper updateBatchIfRequired() : Batch does not have request id and time will add it now.");
            batch.batchData = this.updateBatch(batchJson, MoEDAO.getInstance(context).getSDKIdentifiers());
            if (batch._id != -1L) {
                MoEDAO.getInstance(context).updateBatch(batch);
            }
        }
        catch (Exception e) {
            Logger.f("ReportsBatchHelper updateBatchIfRequired() : Exception ", e);
        }
        return batch;
    }

    JSONObject updateBatch(JSONObject batchJson, SDKIdentifiers identifiers) throws JSONException {
        ReportBatchMeta batchMeta = this.getBatchMeta(batchJson);
        JSONObject metaJson = new JSONObject();
        metaJson.put("bid", (Object)batchMeta.getBatchId());
        metaJson.put("request_time", (Object)batchMeta.getRequestTime());
        JSONObject preferencesJson = this.devicePreferencesJson(batchMeta.getPreferences());
        if (preferencesJson != null) {
            metaJson.put("dev_pref", (Object)preferencesJson);
        }
        batchJson.put("meta", (Object)metaJson);
        String requestId = MoEUtils.getSha1ForString(batchMeta.getBatchId() + batchMeta.getRequestTime() + identifiers.getSdkUniqueId());
        batchJson.put("MOE-REQUEST-ID", (Object)requestId);
        return batchJson;
    }

    ReportBatchMeta getBatchMeta(JSONObject batchJson) {
        ReportBatchMeta batchMeta = this.savedBatchMeta(batchJson);
        if (batchMeta == null) {
            batchMeta = new ReportBatchMeta(null, MoEUtils.getBatchId(), MoEUtils.getCurrentISOTime());
        } else {
            if (MoEUtils.isEmptyString(batchMeta.getBatchId())) {
                batchMeta.setBatchId(MoEUtils.getBatchId());
            }
            if (MoEUtils.isEmptyString(batchMeta.getRequestTime())) {
                batchMeta.setRequestTime(MoEUtils.getCurrentISOTime());
            }
        }
        return batchMeta;
    }

    @Nullable
    ReportBatchMeta savedBatchMeta(JSONObject batchJson) {
        try {
            if (!batchJson.has("meta")) {
                return null;
            }
            JSONObject metaJson = batchJson.getJSONObject("meta");
            ReportBatchMeta batchMeta = new ReportBatchMeta();
            if (metaJson.has("bid")) {
                batchMeta.setBatchId(metaJson.getString("bid"));
            }
            if (metaJson.has("request_time")) {
                batchMeta.setRequestTime(metaJson.getString("request_time"));
            }
            if (metaJson.has("dev_pref")) {
                JSONObject devicePreferences = metaJson.getJSONObject("dev_pref");
                DevicePreferences preferences = new DevicePreferences();
                if (devicePreferences.has("e_t_p")) {
                    preferences.setDataTrackingOptedOut(true);
                }
                if (devicePreferences.has("in_app_p")) {
                    preferences.setInAppOptedOut(true);
                }
                if (devicePreferences.has("push_p")) {
                    preferences.setPushOptedOut(true);
                }
                batchMeta.setPreferences(preferences);
            }
            return batchMeta;
        }
        catch (Exception e) {
            Logger.e("ReportsBatchHelper batchMetaFromJson() : ");
            return null;
        }
    }

    @Nullable
    JSONObject devicePreferencesJson(DevicePreferences preferences) {
        JSONObject preferencesJson = new JSONObject();
        try {
            if (preferences == null) {
                return null;
            }
            if (preferences.isDataTrackingOptedOut()) {
                preferencesJson.put("e_t_p", !preferences.isDataTrackingOptedOut());
            }
            if (preferences.isPushOptedOut()) {
                preferencesJson.put("push_p", !preferences.isPushOptedOut());
            }
            if (preferences.isInAppOptedOut()) {
                preferencesJson.put("in_app_p", !preferences.isInAppOptedOut());
            }
        }
        catch (Exception e) {
            Logger.e("ReportsBatchHelper devicePreferencesJson() : Exception: ", e);
        }
        return preferencesJson.length() > 0 ? preferencesJson : null;
    }

    @Nullable
    JSONObject identifierJson(SDKIdentifiers identifiers) {
        JSONObject identifiersJson = new JSONObject();
        try {
            if (identifiers.getUserAttributeUniqueId() != null) {
                identifiersJson.put("moe_user_id", (Object)identifiers.getUserAttributeUniqueId());
            }
            if (identifiers.getSegmentAnonymousId() != null) {
                identifiersJson.put("segment_id", (Object)identifiers.getSegmentAnonymousId());
            }
        }
        catch (Exception e) {
            Logger.e("ReportsBatchHelper getIdentifiers() : Exception: ", e);
        }
        return identifiersJson.length() > 0 ? identifiersJson : null;
    }
}

