/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.remoteconfig;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.moengage.core.ApiResponseUtility;
import com.moengage.core.Logger;
import com.moengage.core.model.RemoteConfiguration;
import com.moengage.core.rest.Response;
import org.json.JSONException;
import org.json.JSONObject;

class RemoteConfigResponseParser {
    private static final String TAG = "RemoteConfigResponseParser";
    private static final String RESPONSE_ATTR_LOG_ENTRY_STATUS = "le_s";
    private static final String RESPONSE_ATTR_LOG_ENTRY_TOKEN = "le_tkn";
    private static final String RESPONSE_ATTR_PUSH_AMP_SYNC_DELAY = "m_s_t";
    private static final String RESPONSE_ATTR_BLACKLIST_EVENT = "b_e";
    private static final String RESPONSE_ATTR_APP_STATE = "a_s";
    private static final String RESPONSE_ATTR_IN_APP_STATE = "i_s";
    private static final String RESPONSE_ATTR_GEO_STATE = "g_s";
    private static final String RESPONSE_ATTR_PUSH_AMP_STATE = "in_s";
    private static final String RESPONSE_ATTR_EVENT_SYNC_COUNT = "e_b_c";
    private static final String RESPONSE_ATTR_DATA_SYNC_RETRY_INTERVAL = "d_s_r_i";
    private static final String RESPONSE_ATTR_FLUSH_EVENTS = "f_e";
    private static final String RESPONSE_ATTR_PERIODIC_FLUSH_TIME = "p_f_t";
    private static final String RESPONSE_ATTR_PERIODIC_FLUSH_STATE = "p_f_s";
    private static final String RESPONSE_ATTR_CAMPAIGN_ID_EXPIRY = "cid_ex";
    private static final String RESPONSE_ATTR_REAL_TIME_TRIGGER_STATE = "d_t";
    private static final String RESPONSE_ATTR_REAL_TIME_TRIGGER_SYNC_TIME = "dt_s_t";
    private static final String RESPONSE_ATTR_GDPR_WHITELIST_EVENTS = "d_t_w_e";
    private static final String RESPONSE_ATTR_APP_EXIT_EVENT_TRACKING = "e_e_t";
    private static final String RESPONSE_ATTR_USER_ATTRIBUTE_CACHING_TIME = "u_a_c_t";
    private static final String RESPONSE_ATTR_BLOCKED_UNIQUE_ID_REGEX = "b_uid_r";

    RemoteConfigResponseParser() {
    }

    @Nullable
    RemoteConfiguration parseConfigApiResponse(Response response) {
        try {
            JSONObject responseJson = new JSONObject(response.getResponseBody());
            RemoteConfiguration configuration = new RemoteConfiguration();
            if (responseJson.has(RESPONSE_ATTR_LOG_ENTRY_STATUS)) {
                configuration.setLogEntryStatus(this.getStateFromResponse(responseJson, RESPONSE_ATTR_LOG_ENTRY_STATUS, false));
            }
            if (responseJson.has(RESPONSE_ATTR_LOG_ENTRY_TOKEN)) {
                configuration.setLogEntryToken(responseJson.getString(RESPONSE_ATTR_LOG_ENTRY_TOKEN));
            }
            if (responseJson.has(RESPONSE_ATTR_PUSH_AMP_SYNC_DELAY)) {
                configuration.setPushAmpSyncDelay(responseJson.getLong(RESPONSE_ATTR_PUSH_AMP_SYNC_DELAY) * 1000L);
            }
            if (responseJson.has(RESPONSE_ATTR_BLACKLIST_EVENT)) {
                configuration.setBlacklistedEventList(ApiResponseUtility.jsonArrayToStringList(responseJson.getJSONArray(RESPONSE_ATTR_BLACKLIST_EVENT)));
            }
            if (responseJson.has(RESPONSE_ATTR_APP_STATE)) {
                configuration.setAppStatus(this.getStateFromResponse(responseJson, RESPONSE_ATTR_APP_STATE, true));
            }
            if (responseJson.has(RESPONSE_ATTR_IN_APP_STATE)) {
                configuration.setInAppStatus(this.getStateFromResponse(responseJson, RESPONSE_ATTR_IN_APP_STATE, true));
            }
            if (responseJson.has(RESPONSE_ATTR_GEO_STATE)) {
                configuration.setGeofenceStatus(this.getStateFromResponse(responseJson, RESPONSE_ATTR_GEO_STATE, true));
            }
            if (responseJson.has(RESPONSE_ATTR_PUSH_AMP_STATE)) {
                configuration.setPushAmpStatus(this.getStateFromResponse(responseJson, RESPONSE_ATTR_PUSH_AMP_STATE, false));
            }
            if (responseJson.has(RESPONSE_ATTR_EVENT_SYNC_COUNT)) {
                configuration.setEventBatchCount(responseJson.getInt(RESPONSE_ATTR_EVENT_SYNC_COUNT));
            }
            if (responseJson.has(RESPONSE_ATTR_DATA_SYNC_RETRY_INTERVAL)) {
                configuration.setDataSyncRetryInterval(responseJson.getLong(RESPONSE_ATTR_DATA_SYNC_RETRY_INTERVAL) * 1000L);
            }
            if (responseJson.has(RESPONSE_ATTR_FLUSH_EVENTS)) {
                configuration.setFlushEventList(ApiResponseUtility.jsonArrayToStringList(responseJson.getJSONArray(RESPONSE_ATTR_FLUSH_EVENTS)));
            }
            if (responseJson.has(RESPONSE_ATTR_PERIODIC_FLUSH_STATE)) {
                configuration.setPeriodicFlushStatus(this.getStateFromResponse(responseJson, RESPONSE_ATTR_PERIODIC_FLUSH_STATE, true));
            }
            if (responseJson.has(RESPONSE_ATTR_PERIODIC_FLUSH_TIME)) {
                configuration.setPeriodicFlushTime(responseJson.getLong(RESPONSE_ATTR_PERIODIC_FLUSH_TIME));
            }
            if (responseJson.has(RESPONSE_ATTR_CAMPAIGN_ID_EXPIRY)) {
                configuration.setPushAmpCampaignExpiryTime(responseJson.getLong(RESPONSE_ATTR_CAMPAIGN_ID_EXPIRY));
            }
            if (responseJson.has(RESPONSE_ATTR_REAL_TIME_TRIGGER_STATE)) {
                configuration.setRealTimeTriggerStatus(this.getStateFromResponse(responseJson, RESPONSE_ATTR_REAL_TIME_TRIGGER_STATE, false));
            }
            if (responseJson.has(RESPONSE_ATTR_REAL_TIME_TRIGGER_SYNC_TIME)) {
                configuration.setRealTimeTriggerSyncTime(responseJson.getLong(RESPONSE_ATTR_REAL_TIME_TRIGGER_SYNC_TIME) * 1000L);
            }
            if (responseJson.has(RESPONSE_ATTR_GDPR_WHITELIST_EVENTS)) {
                configuration.setGdprWhitelistEventList(ApiResponseUtility.jsonArrayToStringList(responseJson.getJSONArray(RESPONSE_ATTR_GDPR_WHITELIST_EVENTS)));
            }
            if (responseJson.has(RESPONSE_ATTR_APP_EXIT_EVENT_TRACKING)) {
                configuration.setTrackingAppExitStatus(this.getStateFromResponse(responseJson, RESPONSE_ATTR_APP_EXIT_EVENT_TRACKING, false));
            }
            if (responseJson.has(RESPONSE_ATTR_USER_ATTRIBUTE_CACHING_TIME)) {
                configuration.setUserAttributeCachingTime(responseJson.getLong(RESPONSE_ATTR_USER_ATTRIBUTE_CACHING_TIME) * 1000L);
            }
            if (responseJson.has(RESPONSE_ATTR_BLOCKED_UNIQUE_ID_REGEX)) {
                configuration.setBlockedUniqueIdRegex(ApiResponseUtility.jsonArrayToStringList(responseJson.getJSONArray(RESPONSE_ATTR_BLOCKED_UNIQUE_ID_REGEX)));
            }
            return configuration;
        }
        catch (Exception e) {
            Logger.f("RemoteConfigResponseParser parseConfigApiResponse() : Exception ", e);
            return null;
        }
    }

    private boolean getStateFromResponse(@NonNull JSONObject responseJSON, @NonNull String responseAttr, boolean defaultValue) {
        try {
            String state;
            switch (state = responseJSON.getString(responseAttr)) {
                case "blocked": {
                    return false;
                }
                case "allowed": {
                    return true;
                }
            }
        }
        catch (JSONException e) {
            Logger.f("ConfigApiNetworkTask: getStateFromResponse ", e);
        }
        return defaultValue;
    }
}

