/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.remoteconfig;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import com.moengage.core.Logger;
import com.moengage.core.MoEEventManager;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.remoteconfig.RemoteConfigResponseHandler;
import com.moengage.core.rest.Request;
import com.moengage.core.rest.RequestBuilder;
import com.moengage.core.rest.Response;
import com.moengage.core.rest.RestClient;
import com.moengage.core.utils.RestUtils;
import org.json.JSONObject;

public class ConfigApiNetworkTask
extends SDKTask {
    private static final String TAG = "ConfigApiNetworkTask";
    private Context mContext;

    public ConfigApiNetworkTask(Context context) {
        super(context);
        this.mContext = context;
    }

    @Override
    public TaskResult execute() {
        Logger.v("ConfigApiNetworkTask : executing Task");
        try {
            String appId = MoEUtils.getAppId(this.mContext);
            if (TextUtils.isEmpty((CharSequence)appId)) {
                Logger.e("ConfigApiNetworkTask execute(): Cannot make config api sync request without app id.");
                return null;
            }
            Uri.Builder uriBuilder = RestUtils.getBaseUriBuilder(this.mContext).appendEncodedPath("v3/sdkconfig/android/").appendEncodedPath(appId);
            JSONObject requestBody = new JSONObject();
            requestBody.put("query_params", (Object)RestUtils.getDefaultParams(this.mContext).build());
            Request request = RestUtils.getBaseRequestBuilder(uriBuilder.build(), RequestBuilder.RequestType.POST, appId).addBody(requestBody).build();
            RestClient restClient = new RestClient(request);
            Response response = restClient.executeRequest();
            RemoteConfigResponseHandler handler = new RemoteConfigResponseHandler();
            handler.handleConfigApiResponse(this.mContext, response);
            MoEEventManager.getInstance(this.mContext).updateEventListFromRemote();
        }
        catch (Exception e) {
            Logger.f("ConfigApiNetworkTask : execute", e);
        }
        Logger.v("ConfigApiNetworkTask : execution completed");
        return null;
    }

    @Override
    public String getTaskTag() {
        return "SYNC_CONFIG";
    }

    @Override
    public boolean isSynchronous() {
        return true;
    }
}

