/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.ContentProviderOperation;
import android.content.ContentValues;
import android.content.Context;
import android.content.OperationApplicationException;
import android.database.Cursor;
import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.moe.pushlibrary.models.BatchData;
import com.moe.pushlibrary.models.Event;
import com.moe.pushlibrary.models.UserAttribute;
import com.moe.pushlibrary.providers.MoEDataContract;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.model.DevicePreferences;
import com.moengage.core.model.MoEAttribute;
import com.moengage.core.model.RemoteConfiguration;
import com.moengage.core.model.SDKIdentifiers;
import java.util.ArrayList;
import org.json.JSONObject;

public final class MoEDAO {
    private static final String TAG = "MoEDAO";
    private static MoEDAO _INSTANCE = null;
    private Uri MESSAGES_CONTENT_URI = null;
    private Uri INAPP_CONTENT_URI = null;
    private Uri DATAPOINTS_CONTENT_URI = null;
    private Uri USER_ATTRIBUTES_URI = null;
    private Uri CAMPAIGN_LIST_URI = null;
    private Uri BATCHED_DATA_URI = null;
    private Uri ATTRIBUTE_CACHE_URI = null;
    private String AUTHORITY = null;
    private Context mContext;

    public static MoEDAO getInstance(Context context) {
        if (null == _INSTANCE) {
            _INSTANCE = new MoEDAO(context);
        }
        return _INSTANCE;
    }

    private MoEDAO(Context context) {
        this.MESSAGES_CONTENT_URI = MoEDataContract.MessageEntity.getContentUri(context);
        this.INAPP_CONTENT_URI = MoEDataContract.InAppMessageEntity.getContentUri(context);
        this.DATAPOINTS_CONTENT_URI = MoEDataContract.DatapointEntity.getContentUri(context);
        this.USER_ATTRIBUTES_URI = MoEDataContract.UserAttributeEntity.getContentUri(context);
        this.CAMPAIGN_LIST_URI = MoEDataContract.CampaignListEntity.getContentUri(context);
        this.BATCHED_DATA_URI = MoEDataContract.BatchDataEntity.getContentUri(context);
        this.ATTRIBUTE_CACHE_URI = MoEDataContract.AttributeCacheEntity.getContentUri(context);
        this.AUTHORITY = MoEDataContract.getAuthority(context);
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getUnreadMessageCount() {
        int unReadCount = 0;
        Cursor cursor = null;
        try {
            cursor = this.mContext.getContentResolver().query(this.MESSAGES_CONTENT_URI, MoEDataContract.MessageEntity.PROJECTION, "msgclicked = ?", new String[]{"0"}, "gtime DESC");
            if (null != cursor) {
                unReadCount = cursor.getCount();
            }
            Logger.v("Getting Unread PromotionalMessage Count: count=" + unReadCount);
            this.closeCursor(cursor);
        }
        catch (Exception e) {
            Logger.f("MoEDAO getUnreadMessageCount() : Exception: ", e);
        }
        finally {
            this.closeCursor(cursor);
        }
        return unReadCount;
    }

    void addEvent(Event event, Context context) {
        try {
            if (null == event) {
                Logger.v("Null event passed, skipping it");
                return;
            }
            Logger.v("Event : " + event.details);
            ContentValues values = new ContentValues();
            values.put("gtime", Long.valueOf(event.gtime));
            values.put("details", event.details);
            Uri newRecord = context.getContentResolver().insert(this.DATAPOINTS_CONTENT_URI, values);
            if (null != newRecord) {
                Logger.v("New Event added with Uri: " + newRecord.toString());
            } else {
                Logger.v("Unable to add event");
            }
        }
        catch (Exception e) {
            Logger.f("MoEDAO addEvent() : Exception: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    ArrayList<Event> getInteractionData(int batchSize) {
        block8: {
            ArrayList<Event> arrayList;
            Cursor cur = null;
            try {
                Uri CONTENT_URI = this.DATAPOINTS_CONTENT_URI.buildUpon().appendQueryParameter("LIMIT", String.valueOf(batchSize)).build();
                cur = this.mContext.getContentResolver().query(CONTENT_URI, MoEDataContract.DatapointEntity.PROJECTION, null, null, "gtime ASC");
                if (null == cur || cur.getCount() == 0) {
                    Logger.v("Empty cursor");
                    this.closeCursor(cur);
                    ArrayList<Event> arrayList2 = null;
                    this.closeCursor(cur);
                    return arrayList2;
                }
                ArrayList<Event> eventList = new ArrayList<Event>();
                while (cur.moveToNext()) {
                    eventList.add(new Event(cur.getInt(0), cur.getString(2)));
                }
                arrayList = eventList;
                this.closeCursor(cur);
            }
            catch (Exception e) {
                Logger.f("MoEDAO getInteractionData() : Exception: ", e);
                break block8;
            }
            finally {
                this.closeCursor(cur);
            }
            return arrayList;
        }
        return null;
    }

    void deleteInteractionData(ArrayList<Event> events, Context context) {
        ArrayList<ContentProviderOperation> operations = new ArrayList<ContentProviderOperation>();
        for (Event item : events) {
            ContentProviderOperation operation = ContentProviderOperation.newDelete((Uri)this.DATAPOINTS_CONTENT_URI).withSelection("_id = ?", new String[]{String.valueOf(item._id)}).build();
            operations.add(operation);
        }
        try {
            context.getContentResolver().applyBatch(this.AUTHORITY, operations);
        }
        catch (RemoteException e) {
            Logger.f("MoEDAO: deleteInteractionData", e);
        }
        catch (OperationApplicationException e) {
            Logger.f("MoEDAO: deleteInteractionData", e);
        }
        catch (Exception e) {
            Logger.f("MoEDAO: deleteInteractionData", e);
        }
    }

    @Nullable
    Cursor getMessages(Context context) {
        try {
            return context.getContentResolver().query(this.MESSAGES_CONTENT_URI, MoEDataContract.MessageEntity.PROJECTION, null, null, "gtime DESC");
        }
        catch (Exception e) {
            Logger.f("MoEDAO getMessages() : Exception: ", e);
            return null;
        }
    }

    boolean setMessageClicked(long id2) {
        int rowCount = -1;
        try {
            Uri updateRec = this.MESSAGES_CONTENT_URI.buildUpon().appendPath(String.valueOf(id2)).build();
            ContentValues values = new ContentValues();
            values.put("msgclicked", Integer.valueOf(1));
            rowCount = this.mContext.getContentResolver().update(updateRec, values, null, null);
            this.mContext.getContentResolver().notifyChange(updateRec, null);
        }
        catch (Exception e) {
            Logger.f("MoEDAO setMessageClicked() : Exception: ", e);
        }
        return rowCount > 0;
    }

    void removeExpiredData() {
        try {
            String currTime = Long.toString(System.currentTimeMillis());
            int rows = this.mContext.getContentResolver().delete(this.INAPP_CONTENT_URI, "ttl < ? AND status = ?", new String[]{Long.toString(System.currentTimeMillis() / 1000L), "expired"});
            Logger.v("MoEDAO:removeExpiredData: Number of IN APP records deleted: " + rows);
            rows = this.mContext.getContentResolver().delete(this.MESSAGES_CONTENT_URI, "msgttl < ?", new String[]{currTime});
            Logger.v("MoEDAO:removeExpiredData: Number of PromotionalMessage records deleted: " + rows);
            rows = this.mContext.getContentResolver().delete(this.CAMPAIGN_LIST_URI, "ttl < ?", new String[]{currTime});
            Logger.v("MoEDAO:removeExpiredData: Number of CampaignList records deleted: " + rows);
            this.mContext.getContentResolver().notifyChange(this.INAPP_CONTENT_URI, null);
            this.mContext.getContentResolver().notifyChange(this.MESSAGES_CONTENT_URI, null);
        }
        catch (Exception e) {
            Logger.f("MoEDAO removeExpiredData() : Exception: ", e);
        }
    }

    boolean setMessageClickedByTime(long gtime) {
        int rowCount = -1;
        try {
            ContentValues values = new ContentValues();
            values.put("msgclicked", Integer.valueOf(1));
            rowCount = this.mContext.getContentResolver().update(this.MESSAGES_CONTENT_URI, values, "gtime = ? ", new String[]{String.valueOf(gtime)});
            this.mContext.getContentResolver().notifyChange(this.MESSAGES_CONTENT_URI, null);
        }
        catch (Exception e) {
            Logger.f("MoEDAO setMessageClickedByTime() : Exception: ", e);
        }
        return rowCount > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addOrUpdateUserAttribute(@NonNull UserAttribute userAttribute) {
        if (userAttribute == null) {
            return;
        }
        Logger.v("User Attribute -->" + userAttribute.getUserAttributeName() + ":" + userAttribute.getUserAttributeValue());
        ContentValues contentValues = new ContentValues();
        contentValues.put("attribute_name", userAttribute.userAttributeName);
        contentValues.put("attribute_value", userAttribute.userAttributeValue);
        try (Cursor cursor = null;){
            cursor = this.mContext.getContentResolver().query(this.USER_ATTRIBUTES_URI, MoEDataContract.UserAttributeEntity.PROJECTION, "attribute_name=?", new String[]{userAttribute.userAttributeName}, null);
            if (cursor != null && cursor.moveToFirst()) {
                this.updateUserAttribute(userAttribute, contentValues);
            } else {
                this.addUserAttribute(contentValues);
            }
        }
    }

    private void addUserAttribute(ContentValues contentValues) {
        Uri newRecord = this.mContext.getContentResolver().insert(this.USER_ATTRIBUTES_URI, contentValues);
        if (null != newRecord) {
            Logger.v("New user attribute added with Uri: " + newRecord.toString());
        } else {
            Logger.v("Unable to user attribute");
        }
    }

    private void updateUserAttribute(@NonNull UserAttribute userAttribute, ContentValues contentValues) {
        int updateCount = this.mContext.getContentResolver().update(this.USER_ATTRIBUTES_URI, contentValues, "attribute_name=?", new String[]{userAttribute.userAttributeName});
        if (updateCount > 0) {
            Logger.v("New user attribute updated, count: " + updateCount);
        } else {
            Logger.v("Unable to user attribute");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    UserAttribute getUserAttributeByName(@NonNull String attributeName) {
        if (TextUtils.isEmpty((CharSequence)attributeName)) {
            return null;
        }
        Cursor cursor = null;
        UserAttribute userAttribute = null;
        try {
            cursor = this.mContext.getContentResolver().query(this.USER_ATTRIBUTES_URI, MoEDataContract.UserAttributeEntity.PROJECTION, "attribute_name=?", new String[]{attributeName}, null);
            if (cursor != null && cursor.moveToFirst()) {
                userAttribute = new UserAttribute();
                userAttribute.userAttributeName = cursor.getString(1);
                userAttribute.userAttributeValue = cursor.getString(2);
            }
            this.closeCursor(cursor);
        }
        catch (Exception e) {
            Logger.f("MoEDAO getUserAttributeByName() : Exception: ", e);
        }
        finally {
            this.closeCursor(cursor);
        }
        return userAttribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    ArrayList<BatchData> getBatchedData(int batchSize) {
        Uri CONTENT_URI = this.BATCHED_DATA_URI.buildUpon().appendQueryParameter("LIMIT", String.valueOf(batchSize)).build();
        Cursor cursor = null;
        ArrayList<BatchData> batchList = null;
        try {
            cursor = this.mContext.getContentResolver().query(CONTENT_URI, MoEDataContract.BatchDataEntity.PROJECTION, null, null, null);
            if (cursor == null || cursor.getCount() == 0) {
                Logger.v("Empty cursor");
                this.closeCursor(cursor);
                ArrayList<BatchData> arrayList = null;
                this.closeCursor(cursor);
                return arrayList;
            }
            batchList = new ArrayList<BatchData>(cursor.getCount());
            if (cursor.moveToFirst()) {
                do {
                    long _id = cursor.getLong(cursor.getColumnIndex("_id"));
                    String data = cursor.getString(cursor.getColumnIndex("batch_data"));
                    try {
                        batchList.add(new BatchData(_id, new JSONObject(data)));
                    }
                    catch (Exception e) {
                        Logger.f("MoEDAO getBatchedData() : ", e);
                    }
                } while (cursor.moveToNext());
            }
            this.closeCursor(cursor);
        }
        catch (Exception e) {
            Logger.f("MoEDAO getBatchedData() :exception ", e);
        }
        finally {
            this.closeCursor(cursor);
        }
        return batchList;
    }

    void writeBatch(@NonNull String batch) {
        try {
            if (batch == null) {
                return;
            }
            ContentValues values = new ContentValues();
            values.put("batch_data", batch);
            Uri newBatch = this.mContext.getContentResolver().insert(this.BATCHED_DATA_URI, values);
            if (newBatch != null) {
                Logger.v("MoEDAO: writeBatch() New batch added : uri " + newBatch.toString());
            } else {
                Logger.f("MoEDAO: writeBatch() unable to add batch");
            }
        }
        catch (Exception e) {
            Logger.f("MoEDAO writeBatch() : Exception: ", e);
        }
    }

    void deleteBatch(BatchData batch) {
        ArrayList<ContentProviderOperation> operations = new ArrayList<ContentProviderOperation>();
        ContentProviderOperation operation = ContentProviderOperation.newDelete((Uri)this.BATCHED_DATA_URI).withSelection("_id = ?", new String[]{String.valueOf(batch._id)}).build();
        operations.add(operation);
        try {
            this.mContext.getContentResolver().applyBatch(this.AUTHORITY, operations);
        }
        catch (RemoteException e) {
            Logger.f("MoEDAO: deleteInteractionData", e);
        }
        catch (OperationApplicationException e) {
            Logger.f("MoEDAO: deleteInteractionData", e);
        }
        catch (Exception e) {
            Logger.f("MoEDAO: deleteInteractionData", e);
        }
    }

    @WorkerThread
    void deleteAllEvents() {
        try {
            this.mContext.getContentResolver().delete(MoEDataContract.DatapointEntity.getContentUri(this.mContext), null, null);
        }
        catch (Exception e) {
            Logger.f("MoEDAO deleteAllEvents() : Exception: ", e);
        }
    }

    @WorkerThread
    void deleteAllBatches() {
        try {
            this.mContext.getContentResolver().delete(MoEDataContract.BatchDataEntity.getContentUri(this.mContext), null, null);
        }
        catch (Exception e) {
            Logger.f("MoEDAO deleteAllBatches() : Exception: ", e);
        }
    }

    private void closeCursor(Cursor cursor) {
        if (cursor != null) {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @Nullable
    public MoEAttribute getAttributeByName(String attributeName) {
        Cursor cursor = null;
        try {
            cursor = this.mContext.getContentResolver().query(this.ATTRIBUTE_CACHE_URI, MoEDataContract.AttributeCacheEntity.PROJECTION, "name=?", new String[]{attributeName}, null);
            if (cursor != null && cursor.moveToFirst()) {
                MoEAttribute moEAttribute = this.cachedAttributeFromCursor(cursor);
                this.closeCursor(cursor);
                return moEAttribute;
            }
            this.closeCursor(cursor);
        }
        catch (Exception e) {
            Logger.f("MoEDAO getAttributeByName() : ");
        }
        finally {
            this.closeCursor(cursor);
        }
        return null;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void addOrUpdateAttributeToCache(@NonNull MoEAttribute attribute) {
        if (this.isAttributePresentInCache(attribute.getName())) {
            this.updateAttributeCache(attribute);
        } else {
            this.addAttributeToCache(attribute);
        }
    }

    private int updateAttributeCache(@NonNull MoEAttribute attribute) {
        int updateCount = -1;
        try {
            updateCount = this.mContext.getContentResolver().update(this.ATTRIBUTE_CACHE_URI, this.contentValuesFromAttribute(attribute), "name=?", new String[]{attribute.getName()});
            if (updateCount > 0) {
                Logger.v("Attribute cache updated, count: " + updateCount);
            } else {
                Logger.v("Unable to update attribute cache");
            }
        }
        catch (Exception e) {
            Logger.f("MoEDAO updateAttributeCache() : Exception: ", e);
        }
        return updateCount;
    }

    @Nullable
    private Uri addAttributeToCache(@NonNull MoEAttribute attribute) {
        try {
            Uri newRecord = this.mContext.getContentResolver().insert(this.ATTRIBUTE_CACHE_URI, this.contentValuesFromAttribute(attribute));
            if (null != newRecord) {
                Logger.v("New attribute added to cache with Uri: " + newRecord.toString());
            } else {
                Logger.v("Unable to add attribute to cache");
            }
            return newRecord;
        }
        catch (Exception e) {
            Logger.f("MoEDAO addAttributeToCache() : Exception: ", e);
            return null;
        }
    }

    private ContentValues contentValuesFromAttribute(MoEAttribute attribute) {
        ContentValues contentValue = new ContentValues();
        contentValue.put("name", attribute.getName());
        contentValue.put("value", attribute.getValue());
        contentValue.put("last_tracked_time", Long.valueOf(attribute.getLastTrackedTime()));
        contentValue.put("datatype", attribute.getDataType());
        return contentValue;
    }

    private MoEAttribute cachedAttributeFromCursor(Cursor cursor) {
        return new MoEAttribute(cursor.getString(1), cursor.getString(2), cursor.getLong(3), cursor.getString(4));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isAttributePresentInCache(String attributeName) {
        Cursor cursor = null;
        try {
            cursor = this.mContext.getContentResolver().query(this.ATTRIBUTE_CACHE_URI, MoEDataContract.AttributeCacheEntity.PROJECTION, "name=?", new String[]{attributeName}, null);
            if (cursor != null && cursor.moveToFirst()) {
                boolean bl = true;
                this.closeCursor(cursor);
                return bl;
            }
            this.closeCursor(cursor);
        }
        catch (Exception e) {
            Logger.f("MoEDAO isAttributePresentInCache() : Exception ", e);
        }
        finally {
            this.closeCursor(cursor);
        }
        return false;
    }

    void clearAttributeCache() {
        try {
            Logger.v("MoEDAO clearAttributeCache() : Clearing all cached attributes");
            this.mContext.getContentResolver().delete(this.ATTRIBUTE_CACHE_URI, null, null);
        }
        catch (Exception e) {
            Logger.f("MoEDAO clearAttributeCache() : Exception: ", e);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void addOrUpdateRemoteConfiguration(RemoteConfiguration remoteConfiguration) {
        ConfigurationProvider provider = ConfigurationProvider.getInstance(this.mContext);
        Logger.v("MoEDAO addOrUpdateRemoteConfiguration(): Saving or updating remote configuration.");
        provider.setLogEntryStatus(remoteConfiguration.isLogEntryEnabled());
        if (!TextUtils.isEmpty((CharSequence)remoteConfiguration.getLogEntryToken())) {
            provider.setLogEntryKey(remoteConfiguration.getLogEntryToken());
        }
        if (remoteConfiguration.getPushAmpSyncDelay() > 0L) {
            provider.setPushAmpFetchDelayDuration(remoteConfiguration.getPushAmpSyncDelay());
        }
        provider.saveBlackListEventList(MoEUtils.convertListToString(remoteConfiguration.getBlacklistedEventList(), ";"));
        provider.saveAppState(remoteConfiguration.isAppEnabled());
        provider.saveInAppState(remoteConfiguration.isInAppEnabled());
        provider.saveGeoState(remoteConfiguration.isGeofenceEnabled());
        provider.setPushAmpState(remoteConfiguration.isPushAmpEnabled());
        provider.saveEventBatchCount(remoteConfiguration.getEventBatchCount());
        provider.setDataSyncRetryTime(remoteConfiguration.getDataSyncRetryInterval());
        provider.saveFlushEventList(MoEUtils.convertListToString(remoteConfiguration.getFlushEventList(), ";"));
        provider.setPeriodicFlushState(remoteConfiguration.isPeriodicFlushEnabled());
        provider.savePeriodicFlushTime(remoteConfiguration.getPeriodicFlushTime());
        provider.saveCampaignIdTTL(remoteConfiguration.getPushAmpCampaignExpiryTime());
        provider.saveDeviceTriggerState(remoteConfiguration.isRealTimeTriggerEnabled());
        provider.saveDTMinimumSyncDelay(remoteConfiguration.getRealTimeTriggerSyncTime());
        provider.saveGDPRWhiteListEventList(MoEUtils.convertListToString(remoteConfiguration.getGdprWhitelistEventList(), ";"));
        provider.saveAppExitTrackingState(remoteConfiguration.isTrackingAppExitEnabled());
        provider.saveUserAttributeCachingTime(remoteConfiguration.getUserAttributeCachingTime());
        provider.saveBlockedUniqueIdRegex(MoEUtils.convertListToString(remoteConfiguration.getBlockedUniqueIdRegex(), ";"));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void updateConfigApiSyncTime(long time) {
        ConfigurationProvider.getInstance(this.mContext).setLastConfigSyncTime(time);
    }

    public void saveUserAttributeUniqueId(@NonNull MoEAttribute attribute) {
        Logger.v("MoEDAO saveUserAttributeUniqueId(): Will save USER_ATTRIBUTE_UNIQUE_ID in cache table and shared preference.");
        ConfigurationProvider.getInstance(this.mContext).saveUserAttributeUniqueId(attribute.getValue());
        this.addOrUpdateAttributeToCache(attribute);
    }

    public SDKIdentifiers getSDKIdentifiers() {
        ConfigurationProvider provider = ConfigurationProvider.getInstance(this.mContext);
        return new SDKIdentifiers(MoEUtils.getUserAttributeUniqueId(this.mContext), provider.getSegmentAnonymousId(), provider.getCurrentUserId());
    }

    public DevicePreferences getDevicePreferences() {
        ConfigurationProvider provider = ConfigurationProvider.getInstance(this.mContext);
        return new DevicePreferences(provider.isDataTrackingOptedOut(), provider.isPushNotificationOptedOut(), provider.isInAppOptedOut());
    }

    public int updateBatch(BatchData batchData) {
        int updateCount = -1;
        try {
            if (batchData._id == -1L) {
                return -1;
            }
            Uri updateRec = this.BATCHED_DATA_URI.buildUpon().appendPath(String.valueOf(batchData._id)).build();
            ContentValues values = new ContentValues();
            values.put("batch_data", batchData.batchData.toString());
            updateCount = this.mContext.getContentResolver().update(updateRec, values, null, null);
        }
        catch (Exception e) {
            Logger.f("MoEDAO updateBatch() : Exception ", e);
        }
        return updateCount;
    }
}

