/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.support.annotation.Nullable;
import java.util.HashMap;

public class ConfigurationCache {
    private HashMap<String, Object> configMap = new HashMap();
    private static ConfigurationCache instance;
    private static final String MI_APP_KEY = "mi_app_key";
    private static final String MI_APP_ID = "mi_app_id";
    private static final String MI_PUSH_STATE = "mi_push_state";
    private static final String PUSH_SERVICE = "push_service";
    private static final String BAIDU_PUSH_STATE = "baidu_push_state";
    private static final String BACK_STACK_OPT_OUT = "is_back_stack_opted_out";
    private static final String EXTRAS_OPT_OUT = "is_extras_opted_out";
    private static final String OPT_OUT_DEFAULT_INAPP = "is_default_inapp_opted_out";

    private ConfigurationCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConfigurationCache getInstance() {
        if (instance != null) return instance;
        Class<ConfigurationCache> clazz = ConfigurationCache.class;
        synchronized (ConfigurationCache.class) {
            if (instance != null) return instance;
            instance = new ConfigurationCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    void saveMiAppKey(String miAppKey) {
        this.configMap.put(MI_APP_KEY, miAppKey);
    }

    @Nullable
    public String getMiAppKey() {
        if (this.configMap.containsKey(MI_APP_KEY)) {
            return (String)this.configMap.get(MI_APP_KEY);
        }
        return null;
    }

    void saveMiAppId(String miAppId) {
        this.configMap.put(MI_APP_ID, miAppId);
    }

    @Nullable
    public String getMiAppId() {
        if (this.configMap.containsKey(MI_APP_ID)) {
            return (String)this.configMap.get(MI_APP_ID);
        }
        return null;
    }

    void setMiPushState(boolean miPushState) {
        this.configMap.put(MI_PUSH_STATE, miPushState);
    }

    public boolean isMiPushEnabled() {
        return this.configMap.containsKey(MI_PUSH_STATE) && this.configMap.get(MI_PUSH_STATE) == Boolean.TRUE;
    }

    public void setPushService(String pushService) {
        this.configMap.put(PUSH_SERVICE, pushService);
    }

    public String getPushService() {
        String pushService = "FCM";
        if (this.configMap.containsKey(PUSH_SERVICE)) {
            pushService = (String)this.configMap.get(PUSH_SERVICE);
        }
        return pushService;
    }

    void setBaiduPushState(boolean baiduPushState) {
        this.configMap.put(BAIDU_PUSH_STATE, baiduPushState);
    }

    public boolean getBaiduPushState() {
        return this.configMap.containsKey(BAIDU_PUSH_STATE) && this.configMap.get(BAIDU_PUSH_STATE) == Boolean.TRUE;
    }

    public void setBackStackOptOut(boolean backStackOptOut) {
        this.configMap.put(BACK_STACK_OPT_OUT, backStackOptOut);
    }

    public boolean isBackStackOptedOut() {
        return this.configMap.containsKey(BACK_STACK_OPT_OUT) && this.configMap.get(BACK_STACK_OPT_OUT) == Boolean.TRUE;
    }

    public void setExtrasOptOut(boolean extrasOptOut) {
        this.configMap.put(EXTRAS_OPT_OUT, extrasOptOut);
    }

    public boolean isExtrasOptedOut() {
        return this.configMap.containsKey(EXTRAS_OPT_OUT) && this.configMap.get(EXTRAS_OPT_OUT) == Boolean.TRUE;
    }

    public void setDefaultInAppOptOut(boolean defaultInAppOptOut) {
        this.configMap.put(OPT_OUT_DEFAULT_INAPP, defaultInAppOptOut);
    }

    public boolean isDefaultInAppOptedOut() {
        return this.configMap.containsKey(OPT_OUT_DEFAULT_INAPP) && this.configMap.get(OPT_OUT_DEFAULT_INAPP) == Boolean.TRUE;
    }
}

