package com.moengage.core.remoteconfig;

import android.content.Context;
import com.moengage.core.Logger;
import com.moengage.core.MoEDAO;
import com.moengage.core.MoEUtils;
import com.moengage.core.model.RemoteConfiguration;
import com.moengage.core.rest.Response;

/**
 * @author Umang Chamaria
 */
class RemoteConfigResponseHandler {

  private static final String TAG = "RemoteConfigResponseHandler";

  private RemoteConfigResponseParser responseParser;

  RemoteConfigResponseHandler() {
    responseParser = new RemoteConfigResponseParser();
  }

  boolean handleConfigApiResponse(Context context, Response response) {
    try {
      if (response == null) {
        Logger.e(TAG + " handleConfigApiResponse() : response object is null.");
        return false;
      }
      if (response.getResponseCode() != 200) {
        Logger.e(TAG
            + " handleConfigApiResponse() : Network Request failed, error: "
            + response.getErrorMessage());
        return false;
      }
      //update remote configuration
      RemoteConfiguration remoteConfiguration = responseParser.parseConfigApiResponse(response);
      if (remoteConfiguration != null) {
        MoEDAO.getInstance(context).addOrUpdateRemoteConfiguration(remoteConfiguration);
      }
      //update last sync time
      MoEDAO.getInstance(context).updateConfigApiSyncTime(MoEUtils.currentTime());
      return true;
    } catch (Exception e) {
      Logger.f(TAG + " handleConfigApiResponse() : ");
    }
    return false;
  }
}
