package com.moengage.core.model;

import android.support.annotation.Nullable;

/**
 * @author Umang Chamaria
 * Date: 2019-06-07
 */
public class ReportBatchMeta {

  @Nullable private DevicePreferences preferences;
  private String batchId;
  private String requestTime;

  public ReportBatchMeta(){}

  public ReportBatchMeta(@Nullable DevicePreferences preferences, String batchId, String requestTime) {
    this.preferences = preferences;
    this.batchId = batchId;
    this.requestTime = requestTime;
  }

  @Nullable public DevicePreferences getPreferences() {
    return preferences;
  }

  public String getBatchId() {
    return batchId;
  }

  public String getRequestTime() {
    return requestTime;
  }

  public void setPreferences(@Nullable DevicePreferences preferences) {
    this.preferences = preferences;
  }

  public void setBatchId(String batchId) {
    this.batchId = batchId;
  }

  public void setRequestTime(String requestTime) {
    this.requestTime = requestTime;
  }

  @Override public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    ReportBatchMeta batchMeta = (ReportBatchMeta) o;

    if (preferences != null ? !preferences.equals(batchMeta.preferences)
        : batchMeta.preferences != null) {
      return false;
    }
    if (batchId != null ? !batchId.equals(batchMeta.batchId) : batchMeta.batchId != null) {
      return false;
    }
    return requestTime != null ? requestTime.equals(batchMeta.requestTime)
        : batchMeta.requestTime == null;
  }

}
