package com.moengage.core.integrations.segment;

import android.content.Context;
import com.moe.pushlibrary.MoEHelper;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Transform Segment's User Attribute to MoEngage format.
 *
 * @author Umang Chamaria
 * Date: 29/04/19
 */
public class TrackSegmentUserAttributeTask extends SDKTask {

  private Map<String, Object> userAttributesMap;

  private static final String TAG = "TrackSegmentUserAttributeTask";

  public TrackSegmentUserAttributeTask(Context context, Map<String, Object> userAttributesMap) {
    super(context);
    this.userAttributesMap = userAttributesMap;
  }

  @Override public TaskResult execute() {
    try {
      Logger.v(TAG + " execute() : Transforming identifiers to "
          + "MoEngage format.");
      List<String> removeAttributeList = new ArrayList<>();
      for (Map.Entry<String, Object> entry : userAttributesMap.entrySet()) {
        String attributeName = entry.getKey();
        Object attributeValue = entry.getValue();
        if (attributeValue instanceof String && MoEUtils.isDate((String) attributeValue)) {
          MoEHelper.getInstance(mContext).setUserAttributeISODate(attributeName,
              attributeValue.toString());
          removeAttributeList.add(attributeName);
        }
      }
      for (String attribute : removeAttributeList) {
        userAttributesMap.remove(attribute);
      }
      MoEHelper.getInstance(mContext).setUserAttribute(userAttributesMap);
    } catch (Exception e) {
      Logger.f(TAG + " execute() : Exception ", e);
    }
    return null;
  }

  @Override public String getTaskTag() {
    return TAG_TRACK_USER_ATTRIBUTE_SEGMENT;
  }

  @Override public boolean isSynchronous() {
    return false;
  }
}
